/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.net;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.google.common.base.Strings;
import com.polygamma.ogm.net.ConnectionTypes;
import com.polygamma.ogm.net.ConnectivityDescriptor;
import com.polygamma.ogm.net.ConnectivityModule;
import com.polygamma.ogm.net.DescriptorUpdater;
import com.polygamma.ogm.net.SubscriptionDescriptor;
import com.polygamma.ogm.util.AndroidContexts;
import java.util.Collections;
import java.util.Objects;

class SubscriptionsUpdater
implements DescriptorUpdater {
    final ConnectivityModule module;

    @SuppressLint(value={"MissingPermission"})
    static SubscriptionDescriptor descriptorOfTelephony(TelephonyManager tele, Context ctxt) {
        int connType;
        SubscriptionDescriptor.Builder desc = SubscriptionDescriptor.ofBuilder();
        int netType = 0;
        try {
            desc.id(Build.VERSION.SDK_INT >= 30 ? tele.getSubscriptionId() : -1).carrierId(Build.VERSION.SDK_INT >= 28 ? tele.getSimCarrierId() : -1).carrierName(Build.VERSION.SDK_INT >= 28 ? ((CharSequence)Objects.requireNonNullElse(tele.getSimCarrierIdName(), "")).toString() : "").countryCode(Strings.nullToEmpty((String)tele.getSimCountryIso()));
            if (tele.getSimState() == 5) {
                desc.operatorCode(Strings.nullToEmpty((String)tele.getSimOperator())).operatorName(Strings.nullToEmpty((String)tele.getSimOperatorName()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            desc.networkOperatorCode(Strings.nullToEmpty((String)tele.getNetworkOperator())).networkOperatorName(Strings.nullToEmpty((String)tele.getNetworkOperatorName())).networkCountryCode(Strings.nullToEmpty((String)tele.getNetworkCountryIso()));
            if (AndroidContexts.hasPermission(ctxt, "android.permission.READ_PHONE_STATE") || AndroidContexts.hasPermission(ctxt, "android.permission.READ_BASIC_PHONE_STATE")) {
                if (Build.VERSION.SDK_INT >= 24) {
                    netType = tele.getDataNetworkType();
                }
                if (netType == 0) {
                    netType = tele.getNetworkType();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (netType == 0) {
            connType = 0;
        } else {
            connType = ConnectionTypes.ofTelephony(netType);
            if (connType == 0) {
                connType = 3;
            }
        }
        return desc.connectionType(connType).build();
    }

    SubscriptionsUpdater(ConnectivityModule module) {
        TelephonyManager ignored = module.telephony();
        this.module = module;
    }

    @Override
    public boolean update(ConnectivityDescriptor.Builder dst, Context ctxt) {
        SubscriptionDescriptor desc = SubscriptionsUpdater.descriptorOfTelephony(this.module.telephony(), ctxt);
        if (desc.equals(SubscriptionDescriptor.ofBuilder().build())) {
            dst.subscriptions(Collections.emptyList()).activeSubscriptionIndex(-1);
        } else {
            dst.subscriptions(Collections.singletonList(desc)).activeSubscriptionIndex(desc.connectionType() == 0 ? -1 : 0);
        }
        return false;
    }

    @Override
    public void close() {
    }
}

