/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.net;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.Futures;
import com.polygamma.ogm.net.ConnectivityDescriptor;
import com.polygamma.ogm.net.ConnectivityModule;
import com.polygamma.ogm.net.SubscriptionDescriptor;
import com.polygamma.ogm.net.SubscriptionsUpdater;
import com.polygamma.ogm.util.AndroidContexts;
import com.polygamma.ogm.util.DebugBuild;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

@RequiresApi(api=22)
class SubscriptionsUpdaterLollipopMr1
extends SubscriptionsUpdater {
    private static final String TAG = SubscriptionsUpdaterLollipopMr1.class.getSimpleName();
    @VisibleForTesting
    @Nullable
    final SubscriptionManager subscriptions;
    @VisibleForTesting
    @Nullable
    OnSubscriptionsChanged onSubscriptionsChanged;

    @VisibleForTesting
    static int activeSubscriptionId() {
        int id = -1;
        if (Build.VERSION.SDK_INT >= 30) {
            id = SubscriptionManager.getActiveDataSubscriptionId();
        }
        if (id == -1 && Build.VERSION.SDK_INT >= 24) {
            id = SubscriptionManager.getDefaultDataSubscriptionId();
        }
        return id;
    }

    @VisibleForTesting
    static SubscriptionDescriptor descriptorOfInfo(SubscriptionInfo info) {
        SubscriptionDescriptor.Builder desc = SubscriptionDescriptor.ofBuilder();
        desc.id(info.getSubscriptionId()).connectionType(3).countryCode(Strings.nullToEmpty((String)info.getCountryIso()));
        if (Build.VERSION.SDK_INT >= 29) {
            String mcc = Strings.nullToEmpty((String)info.getMccString());
            String mnc = Strings.nullToEmpty((String)info.getMncString());
            String mccmnc = mcc.isEmpty() && mnc.isEmpty() ? "" : Strings.padStart((String)mcc, (int)3, (char)'0') + Strings.padStart((String)mnc, (int)3, (char)'0');
            desc.operatorCode(mccmnc).carrierId(info.getCarrierId()).carrierName(((CharSequence)Objects.requireNonNullElse(info.getCarrierName(), "")).toString());
        } else {
            int mcc = Math.max(info.getMcc(), 0);
            int mnc = Math.max(info.getMnc(), 0);
            if (mcc > 0 || mnc > 0) {
                desc.operatorCode(String.format(Locale.ROOT, "%03d%03d", mcc, mnc));
            }
        }
        return desc.build();
    }

    @VisibleForTesting
    static SubscriptionDescriptor descriptorOfTelephonyOrInfo(TelephonyManager tele, SubscriptionInfo info, boolean active, Context ctxt) {
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                return SubscriptionsUpdater.descriptorOfTelephony(tele.createForSubscriptionId(info.getSubscriptionId()), ctxt);
            }
            catch (Throwable e) {
                DebugBuild.log(TAG, "failed to probe subscription using bound telephony", e);
            }
        }
        return active ? SubscriptionsUpdater.descriptorOfTelephony(tele, ctxt) : SubscriptionsUpdaterLollipopMr1.descriptorOfInfo(info);
    }

    SubscriptionsUpdaterLollipopMr1(ConnectivityModule module, Context ctxt) {
        super(module);
        this.subscriptions = Build.VERSION.SDK_INT >= 33 && !AndroidContexts.hasSystemFeature(ctxt, "android.hardware.telephony.subscription") ? null : AndroidContexts.systemServiceOf(ctxt, SubscriptionManager.class, "telephony_subscription_service");
    }

    private void installOnSubscriptionsChanged() {
        OnSubscriptionsChanged listener;
        assert (this.subscriptions != null);
        OnSubscriptionsChanged onSubscriptionsChanged = listener = Build.VERSION.SDK_INT >= 35 ? new OnSubscriptionsChanged() : (OnSubscriptionsChanged)((Object)Futures.getUnchecked((Future)this.module.sdk().foreground().submit(() -> new OnSubscriptionsChanged())));
        if (Build.VERSION.SDK_INT >= 30) {
            this.subscriptions.addOnSubscriptionsChangedListener((Executor)this.module.sdk().background(), (SubscriptionManager.OnSubscriptionsChangedListener)listener);
        } else {
            this.subscriptions.addOnSubscriptionsChangedListener((SubscriptionManager.OnSubscriptionsChangedListener)listener);
        }
        this.onSubscriptionsChanged = listener;
        DebugBuild.log(TAG, "installed subscriptions changed listener");
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public boolean update(ConnectivityDescriptor.Builder dst, Context ctxt) {
        if (this.subscriptions == null || !AndroidContexts.hasPermission(ctxt, "android.permission.READ_PHONE_STATE")) {
            return super.update(dst, ctxt);
        }
        if (this.onSubscriptionsChanged == null) {
            this.installOnSubscriptionsChanged();
        }
        TelephonyManager tele = this.module.telephony();
        ArrayList<SubscriptionDescriptor> descs = new ArrayList<SubscriptionDescriptor>();
        int activeIdx = -1;
        int activeId = SubscriptionsUpdaterLollipopMr1.activeSubscriptionId();
        for (SubscriptionInfo info : Objects.requireNonNullElse(this.subscriptions.getActiveSubscriptionInfoList(), Collections.emptyList())) {
            boolean active;
            boolean bl = active = activeId != -1 && activeId == info.getSubscriptionId();
            if (active) {
                activeIdx = descs.size();
            }
            descs.add(SubscriptionsUpdaterLollipopMr1.descriptorOfTelephonyOrInfo(tele, info, active, ctxt));
        }
        if (activeIdx == -1 && activeId != -1) {
            try {
                descs.add(SubscriptionsUpdaterLollipopMr1.descriptorOfTelephonyOrInfo(tele, this.subscriptions.getActiveSubscriptionInfo(activeId), true, ctxt));
                activeIdx = descs.size() - 1;
            }
            catch (Throwable e) {
                DebugBuild.log(TAG, "failed to probe active subscription info", e);
            }
        } else if (activeIdx == -1 && Build.VERSION.SDK_INT < 24) {
            activeIdx = descs.size() - 1;
        }
        dst.subscriptions(descs).activeSubscriptionIndex(activeIdx);
        return false;
    }

    @Override
    public void close() {
        try {
            if (this.subscriptions != null && this.onSubscriptionsChanged != null) {
                this.subscriptions.removeOnSubscriptionsChangedListener((SubscriptionManager.OnSubscriptionsChangedListener)this.onSubscriptionsChanged);
                this.onSubscriptionsChanged = null;
            }
        }
        finally {
            super.close();
        }
    }

    private final class OnSubscriptionsChanged
    extends SubscriptionManager.OnSubscriptionsChangedListener {
        private OnSubscriptionsChanged() {
        }

        public void onSubscriptionsChanged() {
            SubscriptionsUpdaterLollipopMr1.this.module.updateAvailable(SubscriptionsUpdaterLollipopMr1.this);
        }
    }
}

