/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.net;

import android.content.Context;
import android.telephony.TelephonyCallback;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.polygamma.ogm.net.ConnectivityDescriptor;
import com.polygamma.ogm.net.ConnectivityModule;
import com.polygamma.ogm.net.SubscriptionsUpdaterLollipopMr1;
import com.polygamma.ogm.util.AndroidContexts;
import com.polygamma.ogm.util.DebugBuild;
import java.util.concurrent.Executor;

@RequiresApi(api=31)
class SubscriptionsUpdaterS
extends SubscriptionsUpdaterLollipopMr1 {
    private static final String TAG = SubscriptionsUpdaterS.class.getSimpleName();
    @VisibleForTesting
    @Nullable
    OnActiveDataSubscriptionIdChanged onActiveDataSubscriptionIdChanged;

    SubscriptionsUpdaterS(ConnectivityModule module, Context ctxt) {
        super(module, ctxt);
    }

    @Override
    public boolean update(ConnectivityDescriptor.Builder dst, Context ctxt) {
        if (this.onActiveDataSubscriptionIdChanged == null && AndroidContexts.hasPermission(ctxt, "android.permission.READ_PHONE_STATE")) {
            this.onActiveDataSubscriptionIdChanged = new OnActiveDataSubscriptionIdChanged();
            this.module.telephony().registerTelephonyCallback((Executor)this.module.sdk().background(), (TelephonyCallback)this.onActiveDataSubscriptionIdChanged);
            DebugBuild.log(TAG, "installed active data subscription listener");
        }
        super.update(dst, ctxt);
        return this.onActiveDataSubscriptionIdChanged != null;
    }

    @Override
    public void close() {
        try {
            if (this.onActiveDataSubscriptionIdChanged != null) {
                this.module.telephony().unregisterTelephonyCallback((TelephonyCallback)this.onActiveDataSubscriptionIdChanged);
                this.onActiveDataSubscriptionIdChanged = null;
            }
        }
        finally {
            super.close();
        }
    }

    private final class OnActiveDataSubscriptionIdChanged
    extends TelephonyCallback
    implements TelephonyCallback.ActiveDataSubscriptionIdListener {
        private OnActiveDataSubscriptionIdChanged() {
        }

        public void onActiveDataSubscriptionIdChanged(int ignored) {
            SubscriptionsUpdaterS.this.module.updateAvailable(SubscriptionsUpdaterS.this);
        }
    }
}

