/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.util;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.polygamma.ogm.util.DebugBuild;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;

public class AndroidContexts {
    private static final String TAG = AndroidContexts.class.getSimpleName();

    public static boolean hasPermission(Context ctxt, String perm) {
        try {
            return ctxt.checkCallingOrSelfPermission(perm) == 0;
        }
        catch (Throwable e) {
            DebugBuild.log(TAG, "failed to check permission %s", perm, e);
            return false;
        }
    }

    public static boolean hasAllPermissions(Context ctxt, String ... perms) {
        for (String perm : perms) {
            if (AndroidContexts.hasPermission(ctxt, perm)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAnyPermissions(Context ctxt, String ... perms) {
        for (String perm : perms) {
            if (!AndroidContexts.hasPermission(ctxt, perm)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSystemFeature(Context ctxt, String feat) {
        PackageManager pman = ctxt.getPackageManager();
        try {
            return pman != null && pman.hasSystemFeature(feat);
        }
        catch (Throwable e) {
            DebugBuild.log(TAG, "failed to test system feature %s", feat, e);
            return false;
        }
    }

    @Nullable
    public static <T> T systemServiceOf(Context ctxt, Class<T> type, String name) {
        try {
            Object srv = ctxt.getSystemService(name);
            return (T)(srv == null || !type.isInstance(srv) ? null : srv);
        }
        catch (Throwable e) {
            DebugBuild.log(TAG, "failed to get system service %s", name, e);
            return null;
        }
    }

    @Nullable
    public static <T, R> R withSystemService(Context ctxt, Class<T> type, String name, Function<T, R> op) {
        T srv = AndroidContexts.systemServiceOf(ctxt, type, name);
        if (srv != null) {
            try {
                return (R)op.apply(srv);
            }
            catch (Throwable e) {
                DebugBuild.log(TAG, "failed to apply operation on system service %s", name, e);
            }
        }
        return null;
    }

    public static <T, R> R withSystemService(Context ctxt, Class<T> type, String name, Function<T, R> op, R dfl) {
        return Objects.requireNonNullElse(AndroidContexts.withSystemService(ctxt, type, name, op), dfl);
    }

    public static String currentProcessName(Context ctxt) {
        List procs;
        String name = "";
        if (Build.VERSION.SDK_INT >= 28) {
            name = Application.getProcessName();
        }
        if (Strings.isNullOrEmpty((String)name)) {
            try {
                Class<?> klass = Class.forName("android.app.ActivityThread");
                Method meth = klass.getDeclaredMethod(Build.VERSION.SDK_INT >= 18 ? "currentProcessName" : "currentPackageName", new Class[0]);
                name = (String)meth.invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                Log.w((String)TAG, (String)"Failed to query process name", (Throwable)e);
                name = "";
            }
        }
        ActivityManager act = AndroidContexts.systemServiceOf(ctxt, ActivityManager.class, "activity");
        int pid = Process.myPid();
        if (act != null && (procs = act.getRunningAppProcesses()) != null) {
            if (Strings.isNullOrEmpty((String)name)) {
                for (ActivityManager.RunningAppProcessInfo proc : procs) {
                    if (proc.pid != pid) continue;
                    name = proc.processName;
                    break;
                }
            }
            if (!Strings.isNullOrEmpty((String)name)) {
                int lowestPid = Integer.MAX_VALUE;
                for (ActivityManager.RunningAppProcessInfo proc : procs) {
                    if (!name.equals(proc.processName) || proc.pid == pid) continue;
                    lowestPid = Math.min(lowestPid, proc.pid);
                }
                if (lowestPid != Integer.MAX_VALUE) {
                    name = name + "." + (pid - lowestPid);
                }
            }
        }
        return Strings.isNullOrEmpty((String)name) ? Integer.toString(pid) : name;
    }

    private AndroidContexts() {
    }
}

