/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.util;

import android.content.ContentResolver;
import android.provider.Settings;
import androidx.annotation.Nullable;
import com.polygamma.ogm.util.DebugBuild;
import com.polygamma.ogm.util.Reflection;
import java.lang.reflect.Method;
import java.util.Objects;

public class AndroidSettings {
    private static final String TAG = AndroidSettings.class.getSimpleName();
    @Nullable
    private static final Method SYSTEM_PROPERTIES_GET;

    public static String getSystemString(String name, String dfl) {
        if (SYSTEM_PROPERTIES_GET == null) {
            return dfl;
        }
        try {
            return Objects.requireNonNullElse((String)SYSTEM_PROPERTIES_GET.invoke(null, name, dfl), dfl);
        }
        catch (Throwable err) {
            DebugBuild.log(TAG, "failed to get system string %s", name, err);
            return dfl;
        }
    }

    public static String getSystemString(String name) {
        return AndroidSettings.getSystemString(name, "");
    }

    public static int getSecureInt(ContentResolver cr, String name, int dfl) {
        try {
            return Settings.Secure.getInt((ContentResolver)cr, (String)name, (int)dfl);
        }
        catch (Throwable e) {
            DebugBuild.log(TAG, "failed to get secure int %s", name, e);
            return dfl;
        }
    }

    public static int getSecureInt(ContentResolver cr, String name) {
        return AndroidSettings.getSecureInt(cr, name, 0);
    }

    public static boolean getSecureBoolean(ContentResolver cr, String name, boolean dfl) {
        return AndroidSettings.getSecureInt(cr, name, dfl ? 1 : 0) != 0;
    }

    public static boolean getSecureBoolean(ContentResolver cr, String name) {
        return AndroidSettings.getSecureBoolean(cr, name, false);
    }

    public static String getSecureString(ContentResolver cr, String name, String dfl) {
        try {
            return Objects.requireNonNullElse(Settings.Secure.getString((ContentResolver)cr, (String)name), dfl);
        }
        catch (Throwable e) {
            DebugBuild.log(TAG, "failed to get secure string %s", name, e);
            return dfl;
        }
    }

    public static String getSecureString(ContentResolver cr, String name) {
        return AndroidSettings.getSecureString(cr, name, "");
    }

    public static int getGlobalInt(ContentResolver cr, String name, int dfl) {
        try {
            return Settings.Global.getInt((ContentResolver)cr, (String)name, (int)dfl);
        }
        catch (Throwable e) {
            DebugBuild.log(TAG, "failed to get global int %s", name, e);
            return dfl;
        }
    }

    public static int getGlobalInt(ContentResolver cr, String name) {
        return AndroidSettings.getGlobalInt(cr, name, 0);
    }

    public static boolean getGlobalBoolean(ContentResolver cr, String name, boolean dfl) {
        return AndroidSettings.getGlobalInt(cr, name, dfl ? 1 : 0) != 0;
    }

    public static boolean getGlobalBoolean(ContentResolver cr, String name) {
        return AndroidSettings.getGlobalBoolean(cr, name, false);
    }

    public static String getGlobalString(ContentResolver cr, String name, String dfl) {
        try {
            return Objects.requireNonNullElse(Settings.Global.getString((ContentResolver)cr, (String)name), dfl);
        }
        catch (Throwable e) {
            DebugBuild.log(TAG, "failed to get global string %s", name, e);
            return dfl;
        }
    }

    public static String getGlobalString(ContentResolver cr, String name) {
        return AndroidSettings.getGlobalString(cr, name, "");
    }

    private AndroidSettings() {
    }

    static {
        Method get = null;
        try {
            get = (Method)Reflection.resolveMember("Landroid/os/SystemProperties.get(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        }
        catch (Throwable err) {
            DebugBuild.log(TAG, "failed to resolve `android.os.SystemProperties`", err);
        }
        SYSTEM_PROPERTIES_GET = get;
    }
}

