/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.util;

public class Bits {
    public static final int SIZE_OF_INT = 32;
    public static final int SIZE_OF_LONG = 64;

    public static int intMaskOf(int i) {
        assert (i >= 0 && i < 32);
        return 1 << i;
    }

    public static long longMaskOf(int i) {
        assert (i >= 0 && i < 64);
        return 1L << i;
    }

    public static int intMaskOfRange(int i, int j) {
        assert (i <= j && i >= 0 && j < 32);
        return -1 - Bits.intMaskOf(i) + 1 & -1 >>> 31 - j;
    }

    public static long longMaskOfRange(int i, int j) {
        assert (i <= j && i >= 0 && j < 64);
        return -1L - Bits.longMaskOf(i) + 1L & -1L >>> 63 - j;
    }

    public static int sizeOfUnsigned(long v) {
        return v == 0L || v == 1L ? 1 : 64 - Long.numberOfLeadingZeros(v) - 1 + ((v & v - 1L) != 0L ? 1 : 0);
    }

    private Bits() {
    }
}

