/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.util;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.polygamma.ogm.util.DebugBuild;
import java.lang.ref.Cleaner;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public abstract class Finalizer {
    private static final Finalizer INSTANCE = Build.VERSION.SDK_INT >= 33 ? new CleaningFinalizer() : new QueueFinalizer();

    public static Runnable register(@NonNull Object ref, Runnable action) {
        return INSTANCE.doRegister(Objects.requireNonNull(ref), action);
    }

    private Finalizer() {
    }

    abstract Runnable doRegister(@NonNull Object var1, Runnable var2);

    @RequiresApi(value=33)
    private static final class CleaningFinalizer
    extends Finalizer {
        private final Cleaner cleaner = Cleaner.create();

        CleaningFinalizer() {
        }

        @Override
        Runnable doRegister(@NonNull Object ref, Runnable action) {
            return this.cleaner.register(ref, action)::clean;
        }
    }

    private static final class QueueFinalizer
    extends Finalizer {
        private static final String TAG = QueueFinalizer.class.getSimpleName();
        private final ReferenceQueue<Object> queue = new ReferenceQueue();

        QueueFinalizer() {
            Thread thread = new Thread(this::runFinalizers);
            thread.setDaemon(true);
            thread.setName("pg-ogm-finalizer");
            thread.start();
        }

        private void runFinalizers() {
            while (true) {
                QueuedReference ref;
                try {
                    ref = (QueuedReference)this.queue.remove();
                }
                catch (InterruptedException e) {
                    DebugBuild.log(TAG, "queue removal interrupted", e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignored) {
                        Thread.yield();
                    }
                    continue;
                }
                ref.clear();
            }
        }

        @Override
        Runnable doRegister(@NonNull Object ref, Runnable action) {
            return new QueuedReference(ref, this.queue, action)::clear;
        }
    }

    private static final class QueuedReference<T>
    extends PhantomReference<T> {
        private final AtomicReference<Runnable> action;

        private QueuedReference(@NonNull T ref, ReferenceQueue<? super T> queue, Runnable action) {
            super(ref, queue);
            this.action = new AtomicReference<Runnable>(action);
        }

        @Override
        public void clear() {
            Runnable act = this.action.getAndSet(null);
            if (act != null) {
                try {
                    act.run();
                }
                finally {
                    super.clear();
                }
            }
        }
    }
}

