/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.util;

import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Gzip {
    public static String compressString(String src) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            String string;
            try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
                gzip.write(src.getBytes(StandardCharsets.UTF_8));
                gzip.finish();
                gzip.flush();
                string = BaseEncoding.base64Url().encode(out.toByteArray());
            }
            return string;
        }
    }

    public static String decompressString(String src) throws IOException {
        try (GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(BaseEncoding.base64Url().decode((CharSequence)src)));){
            String string = new String(ByteStreams.toByteArray((InputStream)gzip), StandardCharsets.UTF_8);
            return string;
        }
    }

    public static ByteBuffer compress(ByteBuffer src) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ByteBuffer byteBuffer;
            try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
                if (src.hasArray()) {
                    gzip.write(src.array(), src.arrayOffset() + src.position(), src.remaining());
                } else {
                    byte[] srcArr = new byte[src.remaining()];
                    src.get(srcArr);
                    gzip.write(srcArr);
                }
                gzip.finish();
                gzip.flush();
                byteBuffer = ByteBuffer.wrap(out.toByteArray());
            }
            return byteBuffer;
        }
    }

    public static byte[] compressBytesRaw(byte[] src) {
        Deflater deflater = new Deflater(9, true);
        deflater.setInput(src);
        deflater.finish();
        int chunkSizeBytes = 2048;
        ByteBuffer dst = ByteBuffer.allocate(Math.max(2048, src.length / 2));
        while (true) {
            int nb = deflater.deflate(dst.array(), dst.arrayOffset() + dst.position(), dst.remaining());
            dst.position(dst.position() + nb);
            if (nb <= 6) {
                dst = ByteBuffer.allocate(dst.capacity() + 2048).put((ByteBuffer)dst.flip());
                continue;
            }
            if (deflater.finished()) break;
        }
        dst.flip();
        return Arrays.copyOfRange(dst.array(), dst.arrayOffset() + dst.position(), dst.arrayOffset() + dst.limit());
    }

    private Gzip() {
    }
}

