/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.util;

import androidx.annotation.Nullable;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.polygamma.ogm.util.BiConsumer;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

public class MoreFutures {
    public static <V> void addFallibleListener(ListenableFuture<V> fut, BiConsumer<V, ? super Throwable> fn, Executor exec) {
        fut.addListener(new FallibleListener(fut, fn), exec);
    }

    public static <V> void addFallibleListener(ListenableFuture<V> fut, BiConsumer<V, ? super Throwable> fn) {
        MoreFutures.addFallibleListener(fut, fn, MoreExecutors.directExecutor());
    }

    public static void cancelAndAwait(@Nullable Future<?> fut) {
        if (fut != null) {
            fut.cancel(false);
            try {
                Futures.getUnchecked(fut);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void cancelAndAwaitAll(Iterable<Future<?>> futs) {
        for (Future<?> fut : futs) {
            if (fut == null) continue;
            fut.cancel(false);
        }
        for (Future<?> fut : futs) {
            if (fut == null) continue;
            try {
                Futures.getUnchecked(fut);
            }
            catch (Throwable throwable) {}
        }
    }

    private MoreFutures() {
    }

    private static final class FallibleListener<V>
    implements Runnable {
        private final ListenableFuture<V> future;
        private final BiConsumer<V, ? super Throwable> consumer;

        private FallibleListener(ListenableFuture<V> future, BiConsumer<V, ? super Throwable> consumer) {
            this.future = Objects.requireNonNull(future);
            this.consumer = Objects.requireNonNull(consumer);
        }

        @Override
        public void run() {
            Object ok;
            try {
                ok = Futures.getDone(this.future);
            }
            catch (Throwable e) {
                this.consumer.accept(null, e instanceof ExecutionException ? e.getCause() : e);
                return;
            }
            this.consumer.accept(ok, null);
        }
    }
}

