/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.util;

import androidx.annotation.RestrictTo;
import com.polygamma.ogm.util.Bits;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public interface ProtobufConstants {
    public static final int TYPE_VARINT = 0;
    public static final int TYPE_64BIT = 1;
    public static final int TYPE_LEN = 2;
    @Deprecated
    public static final int TYPE_START_GROUP = 3;
    @Deprecated
    public static final int TYPE_END_GROUP = 4;
    public static final int TYPE_32BIT = 5;
    public static final int MIN_TYPE = 0;
    public static final int MAX_TYPE = 5;
    public static final int BITS_PER_TYPE = Bits.sizeOfUnsigned(6L);
    public static final int TYPES_MASK = Bits.intMaskOfRange(0, BITS_PER_TYPE - 1);
    public static final int MIN_TAG = 1;
    public static final int MAX_TAG = (1 << 32 - BITS_PER_TYPE) - 1;
    public static final int MAX_VARINT_SIZE = Math.max(ProtobufConstants.sizeOfVarint(-1L), Math.max(ProtobufConstants.sizeOfVarint(ProtobufConstants.varintOfSignedLong(Long.MAX_VALUE)), ProtobufConstants.sizeOfVarint(ProtobufConstants.varintOfSignedLong(Long.MIN_VALUE))));
    public static final int MAX_INT_VARINT_SIZE = Math.max(ProtobufConstants.sizeOfVarint(Integer.toUnsignedLong(-1)), Math.max(ProtobufConstants.sizeOfVarint(ProtobufConstants.varintOfSignedInt(Integer.MAX_VALUE)), ProtobufConstants.sizeOfVarint(ProtobufConstants.varintOfSignedInt(Integer.MIN_VALUE))));

    public static int sizeOfVarint(long val) {
        return Integer.divideUnsigned((Long.numberOfLeadingZeros(val | 1L) ^ 0x3F) * 9 + 73, 64);
    }

    public static int sizeOfTag(int tag) {
        return ProtobufConstants.sizeOfVarint(Integer.toUnsignedLong(tag << 3));
    }

    public static long varintOfSignedLong(long val) {
        return val << 1 ^ val >> 63;
    }

    public static long varintOfSignedInt(int val) {
        return Integer.toUnsignedLong(val << 1 ^ val >> 31);
    }

    public static long signedLongOfVarint(long val) {
        return val >>> 1 ^ -(val & 1L);
    }

    public static int signedIntOfVarint(long val) {
        int i = (int)(val & 0xFFFFFFFFL);
        return i >>> 1 ^ -(i & 1);
    }
}

