/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.util;

import android.os.Build;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.polygamma.ogm.util.ProtobufConstants;
import com.polygamma.ogm.util.ProtobufMessage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ProtobufReader {
    private final ByteBuffer source;
    @VisibleForTesting
    int nextType;

    public ProtobufReader(ByteBuffer source) {
        this.source = source.order() == ByteOrder.LITTLE_ENDIAN ? source : source.slice().order(ByteOrder.LITTLE_ENDIAN);
        this.nextType = -1;
    }

    public boolean hasRemaining() {
        return this.source.hasRemaining();
    }

    @VisibleForTesting
    long readVarint() {
        int a = this.source.get() & 0xFF;
        if (a < 128) {
            return a;
        }
        long v = (long)a & 0x7FL;
        for (int i = 1; i < ProtobufConstants.MAX_VARINT_SIZE; ++i) {
            a = this.source.get() & 0xFF;
            v |= ((long)a & 0x7FL) << i * 7;
            if (a >= 128) continue;
            if (i == ProtobufConstants.MAX_VARINT_SIZE - 1 && a >= 2) break;
            return v;
        }
        throw new IllegalStateException("malformed varint");
    }

    public int readTag() {
        long key = this.readVarint();
        int type = (int)(key & (long)ProtobufConstants.TYPES_MASK);
        int tag = (int)(key >>> ProtobufConstants.BITS_PER_TYPE);
        Preconditions.checkState((Long.compareUnsigned(key, Integer.toUnsignedLong(-1)) <= 0 && type >= 0 && type <= 5 && tag >= 1 && tag <= ProtobufConstants.MAX_TAG ? 1 : 0) != 0, (String)"malformed key: %s", (long)key);
        this.nextType = type;
        return tag;
    }

    public boolean isNextVarint() {
        return this.nextType == 0;
    }

    public boolean isNextFixed64() {
        return this.nextType == 1;
    }

    public boolean isNextFixed32() {
        return this.nextType == 5;
    }

    public boolean isNextSequence() {
        return this.nextType == 2;
    }

    private void consumeNext(int type) {
        Preconditions.checkState((this.nextType == type ? 1 : 0) != 0);
        this.nextType = -1;
    }

    public long readUnsignedLong() {
        this.consumeNext(0);
        return this.readVarint();
    }

    public long readLong() {
        return ProtobufConstants.signedLongOfVarint(this.readUnsignedLong());
    }

    public int readUnsignedInt() {
        return (int)(this.readUnsignedLong() & 0xFFFFFFFFL);
    }

    public int readInt() {
        return ProtobufConstants.signedIntOfVarint(this.readUnsignedLong());
    }

    public boolean readBoolean() {
        return this.readUnsignedLong() != 0L;
    }

    public long readFixedLong() {
        this.consumeNext(1);
        return this.source.getLong();
    }

    public int readFixedInt() {
        this.consumeNext(5);
        return this.source.getInt();
    }

    public double readFixedDouble() {
        return Double.longBitsToDouble(this.readFixedLong());
    }

    public float readFixedFloat() {
        return Float.intBitsToFloat(this.readFixedInt());
    }

    public ByteBuffer readByteBufferView() {
        ByteBuffer view;
        int len;
        this.consumeNext(2);
        long len64 = this.readVarint();
        try {
            len = Math.toIntExact(len64);
        }
        catch (ArithmeticException e) {
            len = -1;
        }
        Preconditions.checkState((len >= 0 ? 1 : 0) != 0, (String)"malformed length: %d", (long)len64);
        if (Build.VERSION.SDK_INT >= 34) {
            view = this.source.slice(this.source.position(), len);
        } else {
            ByteBuffer dup = this.source.duplicate();
            view = ((ByteBuffer)dup.limit(dup.position() + len)).slice();
        }
        this.source.position(this.source.position() + view.remaining());
        return view.order(ByteOrder.LITTLE_ENDIAN);
    }

    public byte[] readByteArray() {
        ByteBuffer view = this.readByteBufferView();
        byte[] rv = new byte[view.remaining()];
        view.get(rv);
        return rv;
    }

    private long[] readLongArray(boolean signed) {
        ProtobufReader view = new ProtobufReader(this.readByteBufferView());
        long[] rv = new long[view.source.remaining() / Math.min(ProtobufConstants.MAX_VARINT_SIZE / 2, 1)];
        int pos = 0;
        while (view.hasRemaining()) {
            long v = view.readVarint();
            if (rv.length == pos) {
                rv = Arrays.copyOf(rv, rv.length * 2 + 1);
            }
            rv[pos++] = signed ? ProtobufConstants.signedLongOfVarint(v) : v;
        }
        return pos == rv.length ? rv : Arrays.copyOf(rv, pos);
    }

    public long[] readUnsignedLongArray() {
        return this.readLongArray(false);
    }

    public long[] readLongArray() {
        return this.readLongArray(true);
    }

    private int[] readIntArray(boolean signed) {
        ProtobufReader view = new ProtobufReader(this.readByteBufferView());
        int[] rv = new int[view.source.remaining() / Math.min(ProtobufConstants.MAX_INT_VARINT_SIZE / 2, 1)];
        int pos = 0;
        while (view.hasRemaining()) {
            long v = view.readVarint();
            if (rv.length == pos) {
                rv = Arrays.copyOf(rv, rv.length * 2 + 1);
            }
            rv[pos++] = signed ? ProtobufConstants.signedIntOfVarint(v) : (int)(v & 0xFFFFFFFFL);
        }
        return pos == rv.length ? rv : Arrays.copyOf(rv, pos);
    }

    public int[] readUnsignedIntArray() {
        return this.readIntArray(false);
    }

    public int[] readIntArray() {
        return this.readIntArray(true);
    }

    public boolean[] readBooleanArray() {
        ProtobufReader view = new ProtobufReader(this.readByteBufferView());
        boolean[] rv = new boolean[view.source.remaining()];
        int pos = 0;
        while (view.hasRemaining()) {
            rv[pos++] = view.readVarint() != 0L;
        }
        return pos == rv.length ? rv : Arrays.copyOf(rv, pos);
    }

    private ByteBuffer readFixedArray(int elemSize) {
        ByteBuffer view = this.readByteBufferView();
        Preconditions.checkState((view.remaining() % elemSize == 0 ? 1 : 0) != 0, (Object)"misaligned fixed length");
        return view;
    }

    public long[] readFixedLongArray() {
        LongBuffer view = this.readFixedArray(8).asLongBuffer();
        long[] rv = new long[view.remaining()];
        view.get(rv);
        return rv;
    }

    public int[] readFixedIntArray() {
        IntBuffer view = this.readFixedArray(4).asIntBuffer();
        int[] rv = new int[view.remaining()];
        view.get(rv);
        return rv;
    }

    public double[] readFixedDoubleArray() {
        DoubleBuffer view = this.readFixedArray(8).asDoubleBuffer();
        double[] rv = new double[view.remaining()];
        view.get(rv);
        return rv;
    }

    public float[] readFixedFloatArray() {
        FloatBuffer view = this.readFixedArray(4).asFloatBuffer();
        float[] rv = new float[view.remaining()];
        view.get(rv);
        return rv;
    }

    public String readUtf8() {
        return StandardCharsets.UTF_8.decode(this.readByteBufferView()).toString();
    }

    public Pair<String, String> readUtf8Pair() {
        ProtobufReader reader = new ProtobufReader(this.readByteBufferView());
        String a = "";
        String b = "";
        block4: while (reader.hasRemaining()) {
            switch (reader.readTag()) {
                case 1: {
                    a = reader.readUtf8();
                    continue block4;
                }
                case 2: {
                    b = reader.readUtf8();
                    continue block4;
                }
            }
            throw new IllegalStateException("unexpected tag");
        }
        return new Pair((Object)a, (Object)b);
    }

    public <M extends ProtobufMessage> M readMessage(M base) {
        return (M)base.mergeFrom(new ProtobufReader(this.readByteBufferView()));
    }

    public <M extends ProtobufMessage> List<M> readRepeatedMessage(List<M> dst, List<M> src, M base) {
        if (src == dst) {
            dst = new ArrayList<M>(1);
        }
        dst.add(this.readMessage(base));
        return dst;
    }

    public void readAndDiscard() {
        switch (this.nextType) {
            case 0: {
                this.readVarint();
                break;
            }
            case 1: {
                this.readFixedLong();
                break;
            }
            case 5: {
                this.readFixedInt();
                break;
            }
            case 2: {
                this.readByteBufferView();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

