/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.util;

import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Consumer;
import com.google.common.base.Preconditions;
import com.polygamma.ogm.util.ProtobufConstants;
import com.polygamma.ogm.util.ProtobufMessage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class ProtobufWriter {
    private ByteBuffer target;

    private ProtobufWriter(ByteBuffer target) {
        this.target = target.order(ByteOrder.LITTLE_ENDIAN);
    }

    public ProtobufWriter() {
        this(ByteBuffer.allocate(64));
    }

    private ByteBuffer ensureRemaining(int min) {
        ByteBuffer target = this.target;
        if (target.remaining() >= min) {
            return target;
        }
        int cap = target.capacity();
        this.target = target = ByteBuffer.allocate(Math.max(cap * 2 + 1, Math.addExact(cap, min))).order(ByteOrder.LITTLE_ENDIAN).put((ByteBuffer)target.flip());
        return target;
    }

    @VisibleForTesting
    ProtobufWriter writeVarint(long val) {
        ByteBuffer target = this.ensureRemaining(ProtobufConstants.MAX_VARINT_SIZE);
        for (int i = 0; i < ProtobufConstants.MAX_VARINT_SIZE; ++i) {
            if (Long.compareUnsigned(val, 128L) < 0) {
                target.put((byte)(val & 0xFFL));
                break;
            }
            target.put((byte)(val & 0x7FL | 0x80L));
            val >>>= 7;
        }
        return this;
    }

    @VisibleForTesting
    ProtobufWriter writeTag(int tag, int type) {
        Preconditions.checkArgument((tag >= 1 && tag <= ProtobufConstants.MAX_TAG ? 1 : 0) != 0);
        return this.writeVarint(Integer.toUnsignedLong(tag << ProtobufConstants.BITS_PER_TYPE | type));
    }

    public ProtobufWriter writeUnsignedLong(int tag, long val) {
        this.ensureRemaining(ProtobufConstants.MAX_VARINT_SIZE + ProtobufConstants.MAX_VARINT_SIZE);
        return this.writeTag(tag, 0).writeVarint(val);
    }

    public ProtobufWriter writeLong(int tag, long val) {
        return this.writeUnsignedLong(tag, ProtobufConstants.varintOfSignedLong(val));
    }

    public ProtobufWriter writeUnsignedInt(int tag, int val) {
        return this.writeUnsignedLong(tag, Integer.toUnsignedLong(val));
    }

    public ProtobufWriter writeInt(int tag, int val) {
        return this.writeUnsignedLong(tag, ProtobufConstants.varintOfSignedInt(val));
    }

    public ProtobufWriter writeBoolean(int tag, boolean val) {
        this.ensureRemaining(ProtobufConstants.MAX_VARINT_SIZE + 1);
        this.writeTag((int)tag, (int)0).target.put((byte)(val ? 1 : 0));
        return this;
    }

    public ProtobufWriter writeFixedLong(int tag, long val) {
        this.ensureRemaining(ProtobufConstants.MAX_VARINT_SIZE + 8);
        this.writeTag((int)tag, (int)1).target.putLong(val);
        return this;
    }

    public ProtobufWriter writeFixedInt(int tag, int val) {
        this.ensureRemaining(ProtobufConstants.MAX_VARINT_SIZE + 4);
        this.writeTag((int)tag, (int)5).target.putInt(val);
        return this;
    }

    public ProtobufWriter writeFixedDouble(int tag, double val) {
        return this.writeFixedLong(tag, Double.doubleToLongBits(val));
    }

    public ProtobufWriter writeFixedFloat(int tag, float val) {
        return this.writeFixedInt(tag, Float.floatToIntBits(val));
    }

    public ProtobufWriter writeByteBuffer(int tag, ByteBuffer src) {
        if (!src.hasRemaining()) {
            return this;
        }
        this.ensureRemaining(ProtobufConstants.MAX_VARINT_SIZE + ProtobufConstants.MAX_VARINT_SIZE + src.remaining());
        this.writeTag((int)tag, (int)2).writeVarint((long)((long)src.remaining())).target.put(src);
        return this;
    }

    public ProtobufWriter writeByteArray(int tag, byte[] src, int off, int len) {
        return this.writeByteBuffer(tag, ByteBuffer.wrap(src, off, len));
    }

    public ProtobufWriter writeByteArray(int tag, byte[] src) {
        return this.writeByteArray(tag, src, 0, src.length);
    }

    private int beginWriteLength(int off, int len, int max) {
        Objects.checkFromIndexSize(off, len, max);
        this.ensureRemaining(ProtobufConstants.MAX_INT_VARINT_SIZE + ProtobufConstants.MAX_INT_VARINT_SIZE);
        int lpos = this.target.position();
        this.target.position(lpos + ProtobufConstants.MAX_INT_VARINT_SIZE + ProtobufConstants.MAX_INT_VARINT_SIZE);
        return lpos;
    }

    private void endWriteLength(int tag, int lpos) {
        int bpos = lpos + ProtobufConstants.MAX_INT_VARINT_SIZE + ProtobufConstants.MAX_INT_VARINT_SIZE;
        int blen = this.target.position() - bpos;
        if (blen == 0) {
            this.target.position(lpos);
            return;
        }
        ByteBuffer body = this.target.duplicate();
        body.position(bpos).limit(bpos + blen);
        this.target.position(lpos);
        this.writeTag((int)tag, (int)2).writeVarint((long)((long)blen)).target.put(body);
    }

    private ProtobufWriter writeLongArray(boolean signed, int tag, long[] src, int off, int len) {
        int lpos = this.beginWriteLength(off, len, src.length);
        this.ensureRemaining(len * ProtobufConstants.MAX_VARINT_SIZE);
        while (len-- > 0) {
            long v = src[off++];
            if (signed) {
                v = ProtobufConstants.varintOfSignedLong(v);
            }
            this.writeVarint(v);
        }
        this.endWriteLength(tag, lpos);
        return this;
    }

    public ProtobufWriter writeUnsignedLongArray(int tag, long[] src, int off, int len) {
        return this.writeLongArray(false, tag, src, off, len);
    }

    public ProtobufWriter writeUnsignedLongArray(int tag, long[] src) {
        return this.writeUnsignedLongArray(tag, src, 0, src.length);
    }

    public ProtobufWriter writeLongArray(int tag, long[] src, int off, int len) {
        return this.writeLongArray(true, tag, src, off, len);
    }

    public ProtobufWriter writeLongArray(int tag, long[] src) {
        return this.writeLongArray(true, tag, src, 0, src.length);
    }

    private ProtobufWriter writeIntArray(boolean signed, int tag, int[] src, int off, int len) {
        int lpos = this.beginWriteLength(off, len, src.length);
        this.ensureRemaining(len * ProtobufConstants.MAX_INT_VARINT_SIZE);
        while (len-- > 0) {
            int v = src[off++];
            this.writeVarint(signed ? ProtobufConstants.varintOfSignedInt(v) : Integer.toUnsignedLong(v));
        }
        this.endWriteLength(tag, lpos);
        return this;
    }

    public ProtobufWriter writeUnsignedIntArray(int tag, int[] src, int off, int len) {
        return this.writeIntArray(false, tag, src, off, len);
    }

    public ProtobufWriter writeUnsignedIntArray(int tag, int[] src) {
        return this.writeUnsignedIntArray(tag, src, 0, src.length);
    }

    public ProtobufWriter writeIntArray(int tag, int[] src, int off, int len) {
        return this.writeIntArray(true, tag, src, off, len);
    }

    public ProtobufWriter writeIntArray(int tag, int[] src) {
        return this.writeIntArray(true, tag, src, 0, src.length);
    }

    public ProtobufWriter writeBooleanArray(int tag, boolean[] src, int off, int len) {
        int lpos = this.beginWriteLength(off, len, src.length);
        ByteBuffer dst = this.ensureRemaining(len);
        while (len-- > 0) {
            dst.put((byte)(src[off++] ? 1 : 0));
        }
        this.endWriteLength(tag, lpos);
        return this;
    }

    public ProtobufWriter writeBooleanArray(int tag, boolean[] src) {
        return this.writeBooleanArray(tag, src, 0, src.length);
    }

    private ByteBuffer beginWriteFixed(int tag, int elemSize, int off, int len, int max) {
        Objects.checkFromIndexSize(off, len, max);
        if (len == 0) {
            return this.target;
        }
        this.ensureRemaining(ProtobufConstants.MAX_VARINT_SIZE + ProtobufConstants.MAX_VARINT_SIZE + len * elemSize);
        return this.writeTag((int)tag, (int)2).writeVarint((long)((long)(len * elemSize))).target;
    }

    public ProtobufWriter writeFixedLongArray(int tag, long[] src, int off, int len) {
        ByteBuffer dst = this.beginWriteFixed(tag, 8, off, len, src.length);
        while (len-- > 0) {
            dst.putLong(src[off++]);
        }
        return this;
    }

    public ProtobufWriter writeFixedLongArray(int tag, long[] src) {
        return this.writeFixedLongArray(tag, src, 0, src.length);
    }

    public ProtobufWriter writeFixedIntArray(int tag, int[] src, int off, int len) {
        ByteBuffer dst = this.beginWriteFixed(tag, 4, off, len, src.length);
        while (len-- > 0) {
            dst.putInt(src[off++]);
        }
        return this;
    }

    public ProtobufWriter writeFixedIntArray(int tag, int[] src) {
        return this.writeFixedIntArray(tag, src, 0, src.length);
    }

    public ProtobufWriter writeFixedDoubleArray(int tag, double[] src, int off, int len) {
        ByteBuffer dst = this.beginWriteFixed(tag, 8, off, len, src.length);
        while (len-- > 0) {
            dst.putDouble(src[off++]);
        }
        return this;
    }

    public ProtobufWriter writeFixedDoubleArray(int tag, double[] src) {
        return this.writeFixedDoubleArray(tag, src, 0, src.length);
    }

    public ProtobufWriter writeFixedFloatArray(int tag, float[] src, int off, int len) {
        ByteBuffer dst = this.beginWriteFixed(tag, 4, off, len, src.length);
        while (len-- > 0) {
            dst.putFloat(src[off++]);
        }
        return this;
    }

    public ProtobufWriter writeFixedFloatArray(int tag, float[] src) {
        return this.writeFixedFloatArray(tag, src, 0, src.length);
    }

    public ProtobufWriter writeUtf8(int tag, String src) {
        return this.writeByteArray(tag, src.getBytes(StandardCharsets.UTF_8));
    }

    public ProtobufWriter writeUtf8Pair(int tag, Pair<String, String> pair) {
        int lpos = this.beginWriteLength(0, 1, 1);
        this.writeUtf8(1, (String)pair.first).writeUtf8(2, (String)pair.second).endWriteLength(tag, lpos);
        return this;
    }

    public ProtobufWriter writeMessage(int tag, ProtobufMessage msg) {
        int lpos = this.beginWriteLength(0, 1, 1);
        msg.writeTo(this);
        this.endWriteLength(tag, lpos);
        return this;
    }

    public ProtobufWriter writeMessage(int tag, Consumer<ProtobufWriter> writer) {
        int lpos = this.beginWriteLength(0, 1, 1);
        writer.accept((Object)this);
        this.endWriteLength(tag, lpos);
        return this;
    }

    public ProtobufWriter writeRepeatedMessage(int tag, Iterable<? extends ProtobufMessage> msgs) {
        for (ProtobufMessage protobufMessage : msgs) {
            this.writeMessage(tag, protobufMessage);
        }
        return this;
    }

    public ByteBuffer finish() {
        ByteBuffer rv = this.target.duplicate();
        rv.flip();
        this.target.clear();
        return rv;
    }
}

