/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.util;

import android.os.Build;
import androidx.core.util.Consumer;
import androidx.core.util.Supplier;
import com.google.common.base.Preconditions;
import com.polygamma.ogm.util.Sync;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Reflection {
    private static final Pattern MEMBER_PATTERN = Pattern.compile("^(L[$_/a-zA-Z0-9]+)\\.([$_a-zA-Z0-9]+|<init>)(?:\\(((?:\\[*(?:Z|B|C|S|I|J|F|D|L[$_/a-zA-Z0-9]+;))*)\\)(\\[*(?:Z|B|C|S|I|J|F|D|V|L[$_/a-zA-Z0-9]+;)))?$");
    private static final ReadWriteLock RESOLVE_LOCK = Sync.newReadWriteLock();
    private static final WeakHashMap<String, Member> RESOLVE_CACHE = new WeakHashMap();

    private static Class<?> resolveClass(String name) throws ClassNotFoundException {
        if (name.startsWith("[")) {
            return Class.forName(name.replace('/', '.'));
        }
        if (name.length() == 1) {
            switch (name.charAt(0)) {
                case 'Z': {
                    return Boolean.TYPE;
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'V': {
                    return Void.TYPE;
                }
            }
            throw new IllegalArgumentException();
        }
        Preconditions.checkArgument((!name.isEmpty() && name.charAt(0) == 'L' && name.charAt(name.length() - 1) == ';' ? 1 : 0) != 0);
        return Class.forName(name.substring(1, name.length() - 1).replace('/', '.'));
    }

    private static Member doResolveMember(String sig) throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException {
        Matcher matcher = MEMBER_PATTERN.matcher(sig);
        Preconditions.checkArgument((boolean)matcher.matches());
        Class<?> klass = Reflection.resolveClass(Objects.requireNonNull(matcher.group(1)) + ';');
        String member = Objects.requireNonNull(matcher.group(2));
        String params = matcher.group(3);
        String ret = matcher.group(4);
        if (params == null) {
            return klass.getField(member);
        }
        ArrayList paramTypes = new ArrayList();
        while (!params.isEmpty()) {
            int idx = 0;
            while (params.charAt(idx) == '[') {
                ++idx;
            }
            if (params.charAt(idx) == 'L') {
                idx = params.indexOf(59);
            }
            paramTypes.add(Reflection.resolveClass(params.substring(0, ++idx)));
            params = params.substring(idx);
        }
        Class[] pt = paramTypes.toArray(new Class[0]);
        if (member.equals("<init>")) {
            return klass.getConstructor(pt);
        }
        Method rv = klass.getMethod(member, pt);
        Preconditions.checkArgument((boolean)rv.getReturnType().equals(Reflection.resolveClass(Objects.requireNonNull(ret))));
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Member resolveMember(String sig) {
        Member rv;
        Lock read = RESOLVE_LOCK.readLock();
        read.lock();
        try {
            rv = RESOLVE_CACHE.get(sig);
            if (rv != null) {
                Member member = rv;
                return member;
            }
        }
        finally {
            read.unlock();
        }
        try {
            rv = Reflection.doResolveMember(sig);
            Lock write = RESOLVE_LOCK.writeLock();
            write.lock();
            try {
                RESOLVE_CACHE.put(sig, rv);
            }
            finally {
                write.unlock();
            }
            return rv;
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static Supplier<Member> resolverOfMember(String sig) {
        return () -> Reflection.resolveMember(sig);
    }

    public static Object adaptValue(Class<?> type, Object got) {
        if (type.equals(Boolean.TYPE)) {
            got = got instanceof Boolean ? got : Boolean.valueOf(((Number)got).longValue() != 0L);
        } else if (type.equals(Byte.TYPE)) {
            got = (byte)((Number)got).longValue();
        } else if (type.equals(Short.TYPE)) {
            got = (short)((Number)got).longValue();
        } else if (type.equals(Character.TYPE)) {
            got = got instanceof Character ? got : Character.valueOf((char)((Number)got).longValue());
        } else if (type.equals(Integer.TYPE)) {
            got = (int)((Number)got).longValue();
        } else if (type.equals(Long.TYPE)) {
            got = ((Number)got).longValue();
        } else if (type.equals(Float.TYPE)) {
            got = Float.valueOf((float)((Number)got).doubleValue());
        } else if (type.equals(Double.TYPE)) {
            got = ((Number)got).doubleValue();
        }
        return got;
    }

    public static boolean isInstance(Member member) {
        return (member.getModifiers() & 8) == 0;
    }

    public static Supplier<Object> invokerOf(Member exec, Supplier<Object> paramSupplier) {
        if (Build.VERSION.SDK_INT >= 26) {
            Preconditions.checkArgument((boolean)(exec instanceof Executable));
        }
        Method method = exec instanceof Method ? (Method)exec : null;
        Constructor ctor = exec instanceof Constructor ? (Constructor)exec : null;
        Preconditions.checkArgument((method != null || ctor != null ? 1 : 0) != 0);
        Class<?>[] paramTypes = Build.VERSION.SDK_INT >= 26 ? ((Executable)exec).getParameterTypes() : (method != null ? method.getParameterTypes() : ctor.getParameterTypes());
        Object[] params = new Object[paramTypes.length];
        for (int i = params.length - 1; i >= 0; --i) {
            params[i] = Reflection.adaptValue(paramTypes[i], paramSupplier.get());
        }
        if (ctor != null) {
            return () -> {
                try {
                    return ctor.newInstance(params);
                }
                catch (Exception err) {
                    throw new RuntimeException(err);
                }
            };
        }
        Class<?> ref = Reflection.isInstance(method) ? paramSupplier.get() : method.getDeclaringClass();
        return () -> {
            try {
                return method.invoke(ref, params);
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
        };
    }

    public static Supplier<Object> readerOf(Field field, Supplier<Object> instance) {
        return () -> {
            try {
                return field.get(Reflection.isInstance(field) ? instance.get() : field.getDeclaringClass());
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
        };
    }

    public static Consumer<Object> writerOf(Field field, Supplier<Object> instance) {
        return value -> {
            try {
                field.set(Reflection.isInstance(field) ? instance.get() : field.getDeclaringClass(), Reflection.adaptValue(field.getType(), value));
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
        };
    }

    private Reflection() {
    }
}

