/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.base.CaseFormat;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocNodeImpl;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocLexer;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtils;
import java.util.ArrayDeque;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.FailedPredicateException;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class JavadocDetailNodeParser {
    public static final String MSG_JAVADOC_MISSED_HTML_CLOSE = "javadoc.missed.html.close";
    public static final String MSG_JAVADOC_WRONG_SINGLETON_TAG = "javadoc.wrong.singleton.html.tag";
    public static final String MSG_JAVADOC_PARSE_RULE_ERROR = "javadoc.parse.rule.error";
    public static final String MSG_KEY_PARSE_ERROR = "javadoc.parse.error";
    private static final String JAVADOC_START = "/**";
    private int blockCommentLineNumber;
    private DescriptiveErrorListener errorListener;

    public ParseStatus parseJavadocAsDetailNode(DetailAST javadocCommentAst) {
        this.blockCommentLineNumber = javadocCommentAst.getLineNo();
        String javadocComment = JavadocUtils.getJavadocCommentContent(javadocCommentAst);
        this.errorListener = new DescriptiveErrorListener();
        this.errorListener.setOffset(javadocCommentAst.getLineNo() - 1);
        ParseStatus result = new ParseStatus();
        try {
            ParseTree parseTree = this.parseJavadocAsParseTree(javadocComment);
            DetailNode tree = this.convertParseTreeToDetailNode(parseTree);
            this.adjustFirstLineToJavadocIndent(tree, javadocCommentAst.getColumnNo() + JAVADOC_START.length());
            result.setTree(tree);
        }
        catch (IllegalArgumentException | ParseCancellationException ex) {
            RecognitionException recognitionEx;
            ParseErrorMessage parseErrorMessage = null;
            if ((ex.getCause() instanceof FailedPredicateException || ex.getCause() instanceof NoViableAltException) && (recognitionEx = (RecognitionException)ex.getCause()).getCtx() instanceof JavadocParser.HtmlTagContext) {
                Token htmlTagNameStart = JavadocDetailNodeParser.getMissedHtmlTag(recognitionEx);
                parseErrorMessage = new ParseErrorMessage(this.errorListener.offset + htmlTagNameStart.getLine(), MSG_JAVADOC_MISSED_HTML_CLOSE, htmlTagNameStart.getCharPositionInLine(), htmlTagNameStart.getText());
            }
            if (parseErrorMessage == null) {
                parseErrorMessage = this.errorListener.getErrorMessage();
            }
            result.setParseErrorMessage(parseErrorMessage);
        }
        return result;
    }

    private ParseTree parseJavadocAsParseTree(String blockComment) {
        ANTLRInputStream input = new ANTLRInputStream(blockComment);
        JavadocLexer lexer = new JavadocLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        JavadocParser parser = new JavadocParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)this.errorListener);
        parser.setErrorHandler((ANTLRErrorStrategy)new JavadocParserErrorStrategy());
        return parser.javadoc();
    }

    private DetailNode convertParseTreeToDetailNode(ParseTree parseTreeNode) {
        JavadocNodeImpl rootJavadocNode;
        JavadocNodeImpl currentJavadocParent = rootJavadocNode = this.createRootJavadocNode(parseTreeNode);
        ParseTree parseTreeParent = parseTreeNode;
        while (currentJavadocParent != null) {
            if (currentJavadocParent.getType() == 10079) {
                currentJavadocParent.setChildren(JavadocNodeImpl.EMPTY_DETAIL_NODE_ARRAY);
            }
            JavadocNodeImpl[] children = (JavadocNodeImpl[])currentJavadocParent.getChildren();
            this.insertChildrenNodes(children, parseTreeParent);
            if (children.length > 0) {
                currentJavadocParent = children[0];
                parseTreeParent = parseTreeParent.getChild(0);
                continue;
            }
            JavadocNodeImpl nextJavadocSibling = (JavadocNodeImpl)JavadocUtils.getNextSibling(currentJavadocParent);
            ParseTree nextParseTreeSibling = JavadocDetailNodeParser.getNextSibling(parseTreeParent);
            if (nextJavadocSibling == null) {
                JavadocNodeImpl tempJavadocParent = (JavadocNodeImpl)currentJavadocParent.getParent();
                ParseTree tempParseTreeParent = parseTreeParent.getParent();
                while (nextJavadocSibling == null && tempJavadocParent != null) {
                    nextJavadocSibling = (JavadocNodeImpl)JavadocUtils.getNextSibling(tempJavadocParent);
                    nextParseTreeSibling = JavadocDetailNodeParser.getNextSibling(tempParseTreeParent);
                    tempJavadocParent = (JavadocNodeImpl)tempJavadocParent.getParent();
                    tempParseTreeParent = tempParseTreeParent.getParent();
                }
            }
            currentJavadocParent = nextJavadocSibling;
            parseTreeParent = nextParseTreeSibling;
        }
        return rootJavadocNode;
    }

    private void insertChildrenNodes(JavadocNodeImpl[] nodes, ParseTree parseTreeParent) {
        for (int i = 0; i < nodes.length; ++i) {
            JavadocNodeImpl currentJavadocNode = nodes[i];
            ParseTree currentParseTreeNodeChild = parseTreeParent.getChild(i);
            JavadocNodeImpl[] subChildren = this.createChildrenNodes(currentJavadocNode, currentParseTreeNodeChild);
            currentJavadocNode.setChildren(subChildren);
        }
    }

    private JavadocNodeImpl[] createChildrenNodes(JavadocNodeImpl parentJavadocNode, ParseTree parseTreeNode) {
        JavadocNodeImpl[] children = new JavadocNodeImpl[parseTreeNode.getChildCount()];
        for (int j = 0; j < children.length; ++j) {
            JavadocNodeImpl child;
            children[j] = child = this.createJavadocNode(parseTreeNode.getChild(j), parentJavadocNode, j);
        }
        return children;
    }

    private JavadocNodeImpl createRootJavadocNode(ParseTree parseTreeNode) {
        JavadocNodeImpl rootJavadocNode = this.createJavadocNode(parseTreeNode, null, -1);
        int childCount = parseTreeNode.getChildCount();
        DetailNode[] children = rootJavadocNode.getChildren();
        for (int i = 0; i < childCount; ++i) {
            JavadocNodeImpl child = this.createJavadocNode(parseTreeNode.getChild(i), rootJavadocNode, i);
            children[i] = child;
        }
        rootJavadocNode.setChildren(children);
        return rootJavadocNode;
    }

    private JavadocNodeImpl createJavadocNode(ParseTree parseTree, DetailNode parent, int index) {
        JavadocNodeImpl node = new JavadocNodeImpl();
        if (parseTree.getChildCount() == 0 || "Text".equals(JavadocDetailNodeParser.getNodeClassNameWithoutContext(parseTree))) {
            node.setText(parseTree.getText());
        } else {
            node.setText(JavadocDetailNodeParser.getFormattedNodeClassNameWithoutContext(parseTree));
        }
        node.setColumnNumber(JavadocDetailNodeParser.getColumn(parseTree));
        node.setLineNumber(JavadocDetailNodeParser.getLine(parseTree) + this.blockCommentLineNumber);
        node.setIndex(index);
        node.setType(JavadocDetailNodeParser.getTokenType(parseTree));
        node.setParent(parent);
        node.setChildren(new JavadocNodeImpl[parseTree.getChildCount()]);
        return node;
    }

    private void adjustFirstLineToJavadocIndent(DetailNode tree, int javadocColumnNumber) {
        if (tree.getLineNumber() == this.blockCommentLineNumber) {
            DetailNode[] children;
            ((JavadocNodeImpl)tree).setColumnNumber(tree.getColumnNumber() + javadocColumnNumber);
            for (DetailNode child : children = tree.getChildren()) {
                this.adjustFirstLineToJavadocIndent(child, javadocColumnNumber);
            }
        }
    }

    private static int getLine(ParseTree tree) {
        int line;
        if (tree instanceof TerminalNode) {
            line = ((TerminalNode)tree).getSymbol().getLine() - 1;
        } else {
            ParserRuleContext rule = (ParserRuleContext)tree;
            line = rule.start.getLine() - 1;
        }
        return line;
    }

    private static int getColumn(ParseTree tree) {
        int column;
        if (tree instanceof TerminalNode) {
            column = ((TerminalNode)tree).getSymbol().getCharPositionInLine();
        } else {
            ParserRuleContext rule = (ParserRuleContext)tree;
            column = rule.start.getCharPositionInLine();
        }
        return column;
    }

    private static ParseTree getNextSibling(ParseTree node) {
        ParseTree nextSibling = null;
        if (node.getParent() != null) {
            ParseTree parent = node.getParent();
            int index = 0;
            while (true) {
                ParseTree currentNode;
                if ((currentNode = parent.getChild(index)).equals(node)) {
                    nextSibling = parent.getChild(index + 1);
                    break;
                }
                ++index;
            }
        }
        return nextSibling;
    }

    private static int getTokenType(ParseTree node) {
        int tokenType;
        if (node.getChildCount() == 0) {
            tokenType = ((TerminalNode)node).getSymbol().getType();
        } else {
            String className = JavadocDetailNodeParser.getNodeClassNameWithoutContext(node);
            String typeName = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, className);
            tokenType = JavadocUtils.getTokenId(typeName);
        }
        return tokenType;
    }

    private static String getFormattedNodeClassNameWithoutContext(ParseTree node) {
        String classNameWithoutContext = JavadocDetailNodeParser.getNodeClassNameWithoutContext(node);
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, classNameWithoutContext);
    }

    private static String getNodeClassNameWithoutContext(ParseTree node) {
        String className = node.getClass().getSimpleName();
        int contextLength = 7;
        return className.substring(0, className.length() - 7);
    }

    private static Token getMissedHtmlTag(RecognitionException exception) {
        Token htmlTagNameStart = null;
        Interval sourceInterval = exception.getCtx().getSourceInterval();
        List tokenList = ((BufferedTokenStream)exception.getInputStream()).getTokens(sourceInterval.a, sourceInterval.b);
        ArrayDeque<Token> stack = new ArrayDeque<Token>();
        for (int i = 0; i < tokenList.size(); ++i) {
            Token token = (Token)tokenList.get(i);
            if (token.getType() == 92 && ((Token)tokenList.get(i - 1)).getType() == 5) {
                stack.push(token);
                continue;
            }
            if (token.getType() != 92 || stack.isEmpty()) continue;
            if (((Token)stack.peek()).getText().equals(token.getText())) {
                stack.pop();
                continue;
            }
            htmlTagNameStart = (Token)stack.pop();
        }
        if (htmlTagNameStart == null) {
            htmlTagNameStart = (Token)stack.pop();
        }
        return htmlTagNameStart;
    }

    private static class JavadocParserErrorStrategy
    extends BailErrorStrategy {
        private JavadocParserErrorStrategy() {
        }

        public Token recoverInline(Parser recognizer) {
            this.reportError(recognizer, (RecognitionException)new InputMismatchException(recognizer));
            return super.recoverInline(recognizer);
        }
    }

    public static class ParseErrorMessage {
        private final int lineNumber;
        private final String messageKey;
        private final Object[] messageArguments;

        ParseErrorMessage(int lineNumber, String messageKey, Object ... messageArguments) {
            this.lineNumber = lineNumber;
            this.messageKey = messageKey;
            this.messageArguments = (Object[])messageArguments.clone();
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getMessageKey() {
            return this.messageKey;
        }

        public Object[] getMessageArguments() {
            return (Object[])this.messageArguments.clone();
        }
    }

    public static class ParseStatus {
        private DetailNode tree;
        private ParseErrorMessage parseErrorMessage;

        public DetailNode getTree() {
            return this.tree;
        }

        public void setTree(DetailNode tree) {
            this.tree = tree;
        }

        public ParseErrorMessage getParseErrorMessage() {
            return this.parseErrorMessage;
        }

        public void setParseErrorMessage(ParseErrorMessage parseErrorMessage) {
            this.parseErrorMessage = parseErrorMessage;
        }
    }

    private static class DescriptiveErrorListener
    extends BaseErrorListener {
        private int offset;
        private ParseErrorMessage errorMessage;

        private DescriptiveErrorListener() {
        }

        private ParseErrorMessage getErrorMessage() {
            return this.errorMessage;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
            int lineNumber = this.offset + line;
            if (JavadocDetailNodeParser.MSG_JAVADOC_WRONG_SINGLETON_TAG.equals(msg)) {
                this.errorMessage = new ParseErrorMessage(lineNumber, JavadocDetailNodeParser.MSG_JAVADOC_WRONG_SINGLETON_TAG, charPositionInLine, ((Token)offendingSymbol).getText());
                throw new IllegalArgumentException(msg);
            }
            int ruleIndex = ex.getCtx().getRuleIndex();
            String ruleName = recognizer.getRuleNames()[ruleIndex];
            String upperCaseRuleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, ruleName);
            this.errorMessage = new ParseErrorMessage(lineNumber, JavadocDetailNodeParser.MSG_JAVADOC_PARSE_RULE_ERROR, charPositionInLine, msg, upperCaseRuleName);
        }
    }
}

