/*
 * Decompiled with CFR 0.152.
 */
package com.roomorama.caldroid;

import hirondelle.date4j.DateTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class CalendarHelper {
    private static SimpleDateFormat yyyyMMddFormat;

    public static void setup() {
        yyyyMMddFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
    }

    public static ArrayList<DateTime> getFullWeeks(int month, int year, int startDayOfWeek, boolean sixWeeksInCalendar) {
        DateTime dateTime;
        ArrayList<DateTime> datetimeList = new ArrayList<DateTime>();
        DateTime firstDateOfMonth = new DateTime(Integer.valueOf(year), Integer.valueOf(month), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
        DateTime lastDateOfMonth = firstDateOfMonth.plusDays(Integer.valueOf(firstDateOfMonth.getNumDaysInMonth() - 1));
        int weekdayOfFirstDate = firstDateOfMonth.getWeekDay();
        if (weekdayOfFirstDate < startDayOfWeek) {
            weekdayOfFirstDate += 7;
        }
        while (weekdayOfFirstDate > 0 && (dateTime = firstDateOfMonth.minusDays(Integer.valueOf(weekdayOfFirstDate - startDayOfWeek))).lt(firstDateOfMonth)) {
            datetimeList.add(dateTime);
            --weekdayOfFirstDate;
        }
        for (int i = 0; i < lastDateOfMonth.getDay(); ++i) {
            datetimeList.add(firstDateOfMonth.plusDays(Integer.valueOf(i)));
        }
        int endDayOfWeek = startDayOfWeek - 1;
        if (endDayOfWeek == 0) {
            endDayOfWeek = 7;
        }
        if (lastDateOfMonth.getWeekDay() != endDayOfWeek) {
            DateTime nextDay;
            int i = 1;
            do {
                nextDay = lastDateOfMonth.plusDays(Integer.valueOf(i));
                datetimeList.add(nextDay);
                ++i;
            } while (nextDay.getWeekDay() != endDayOfWeek);
        }
        if (sixWeeksInCalendar) {
            int size = datetimeList.size();
            int row = size / 7;
            int numOfDays = (6 - row) * 7;
            DateTime lastDateTime = datetimeList.get(size - 1);
            for (int i = 1; i <= numOfDays; ++i) {
                DateTime nextDateTime = lastDateTime.plusDays(Integer.valueOf(i));
                datetimeList.add(nextDateTime);
            }
        }
        return datetimeList;
    }

    public static DateTime convertDateToDateTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        int year = calendar.get(1);
        int javaMonth = calendar.get(2);
        int day = calendar.get(5);
        return new DateTime(Integer.valueOf(year), Integer.valueOf(javaMonth + 1), Integer.valueOf(day), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
    }

    public static Date convertDateTimeToDate(DateTime dateTime) {
        int year = dateTime.getYear();
        int datetimeMonth = dateTime.getMonth();
        int day = dateTime.getDay();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(year, datetimeMonth - 1, day);
        return calendar.getTime();
    }

    public static Date getDateFromString(String dateString, String dateFormat) throws ParseException {
        SimpleDateFormat formatter;
        if (dateFormat == null) {
            if (yyyyMMddFormat == null) {
                CalendarHelper.setup();
            }
            formatter = yyyyMMddFormat;
        } else {
            formatter = new SimpleDateFormat(dateFormat, Locale.ENGLISH);
        }
        return formatter.parse(dateString);
    }

    public static DateTime getDateTimeFromString(String dateString, String dateFormat) {
        try {
            Date date = CalendarHelper.getDateFromString(dateString, dateFormat);
            return CalendarHelper.convertDateToDateTime(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList<String> convertToStringList(ArrayList<DateTime> dateTimes) {
        ArrayList<String> list = new ArrayList<String>();
        for (DateTime dateTime : dateTimes) {
            list.add(dateTime.format("YYYY-MM-DD"));
        }
        return list;
    }
}

