/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.krypto;

import com.soywiz.krypto.Padding;
import com.soywiz.krypto.internal.KryptoToolsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000bJH\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0016\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000bR\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/soywiz/krypto/AES;", "", "key", "", "([B)V", "keyWords", "", "([I)V", "invKeySchedule", "keySchedule", "keySize", "", "getKeyWords", "()[I", "ksRows", "numRounds", "decryptBlock", "", "M", "offset", "doCryptBlock", "SUB_MIX_0", "SUB_MIX_1", "SUB_MIX_2", "SUB_MIX_3", "SBOX", "encryptBlock", "Companion", "krypto_release"})
public final class AES {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final int[] keyWords;
    private final int keySize;
    private final int numRounds;
    private final int ksRows;
    @NotNull
    private final int[] keySchedule;
    @NotNull
    private final int[] invKeySchedule;
    @NotNull
    private static final int[] SBOX;
    @NotNull
    private static final int[] INV_SBOX;
    @NotNull
    private static final int[] SUB_MIX_0;
    @NotNull
    private static final int[] SUB_MIX_1;
    @NotNull
    private static final int[] SUB_MIX_2;
    @NotNull
    private static final int[] SUB_MIX_3;
    @NotNull
    private static final int[] INV_SUB_MIX_0;
    @NotNull
    private static final int[] INV_SUB_MIX_1;
    @NotNull
    private static final int[] INV_SUB_MIX_2;
    @NotNull
    private static final int[] INV_SUB_MIX_3;
    @NotNull
    private static final int[] RCON;
    private static final int BLOCK_SIZE = 16;

    /*
     * WARNING - void declaration
     */
    public AES(@NotNull int[] keyWords) {
        void $this$invKeySchedule_u24lambda_u2d1;
        int offset$iv;
        int[] $this$keySchedule_u24lambda_u2d0;
        this.keyWords = keyWords;
        this.keySize = this.keyWords.length;
        this.numRounds = this.keySize + 6;
        this.ksRows = (this.numRounds + 1) * 4;
        int[] nArray = new int[this.ksRows];
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray2 = nArray;
        AES aES = this;
        boolean bl3 = false;
        int n = 0;
        int n2 = $this$keySchedule_u24lambda_u2d0.length;
        if (n < n2) {
            do {
                int $this$ext8$iv;
                boolean $i$f$ext8;
                int n3;
                int ksRow;
                if ((ksRow = n++) < this.keySize) {
                    n3 = this.getKeyWords()[ksRow];
                    continue;
                }
                int t = $this$keySchedule_u24lambda_u2d0[ksRow - 1];
                if (ksRow % this.keySize == 0) {
                    int n4 = t = t << 8 | t >>> 24;
                    offset$iv = 24;
                    $i$f$ext8 = false;
                    int n5 = SBOX[$this$ext8$iv >>> offset$iv & 0xFF] << 24;
                    $this$ext8$iv = t;
                    offset$iv = 16;
                    $i$f$ext8 = false;
                    int n6 = n5 | SBOX[$this$ext8$iv >>> offset$iv & 0xFF] << 16;
                    $this$ext8$iv = t;
                    offset$iv = 8;
                    $i$f$ext8 = false;
                    t = n6 | SBOX[$this$ext8$iv >>> offset$iv & 0xFF] << 8 | SBOX[t & 0xFF];
                    t ^= RCON[ksRow / this.keySize | 0] << 24;
                } else if (this.keySize > 6 && ksRow % this.keySize == 4) {
                    $this$ext8$iv = t;
                    offset$iv = 24;
                    $i$f$ext8 = false;
                    int n7 = SBOX[$this$ext8$iv >>> offset$iv & 0xFF] << 24;
                    $this$ext8$iv = t;
                    offset$iv = 16;
                    $i$f$ext8 = false;
                    int n8 = n7 | SBOX[$this$ext8$iv >>> offset$iv & 0xFF] << 16;
                    $this$ext8$iv = t;
                    offset$iv = 8;
                    $i$f$ext8 = false;
                    t = n8 | SBOX[$this$ext8$iv >>> offset$iv & 0xFF] << 8 | SBOX[t & 0xFF];
                }
                n3 = $this$keySchedule_u24lambda_u2d0[ksRow] = $this$keySchedule_u24lambda_u2d0[ksRow - this.keySize] ^ t;
            } while (n < n2);
        }
        Unit unit = Unit.INSTANCE;
        aES.keySchedule = nArray;
        nArray = new int[this.ksRows];
        bl = false;
        bl2 = false;
        $this$keySchedule_u24lambda_u2d0 = nArray;
        aES = this;
        boolean bl4 = false;
        n = 0;
        n2 = ((void)$this$invKeySchedule_u24lambda_u2d1).length;
        if (n < n2) {
            do {
                int $this$ext8$iv;
                int n9;
                int t;
                int invKsRow = n++;
                int ksRow = this.ksRows - invKsRow;
                int n10 = t = invKsRow % 4 != 0 ? this.keySchedule[ksRow] : this.keySchedule[ksRow - 4];
                if (invKsRow < 4 || ksRow <= 4) {
                    n9 = t;
                    continue;
                }
                offset$iv = t;
                int offset$iv2 = 24;
                boolean $i$f$ext8 = false;
                int n11 = INV_SUB_MIX_0[SBOX[$this$ext8$iv >>> offset$iv2 & 0xFF]];
                $this$ext8$iv = t;
                offset$iv2 = 16;
                $i$f$ext8 = false;
                int n12 = n11 ^ INV_SUB_MIX_1[SBOX[$this$ext8$iv >>> offset$iv2 & 0xFF]];
                $this$ext8$iv = t;
                offset$iv2 = 8;
                $i$f$ext8 = false;
                n9 = $this$invKeySchedule_u24lambda_u2d1[invKsRow] = n12 ^ INV_SUB_MIX_2[SBOX[$this$ext8$iv >>> offset$iv2 & 0xFF]] ^ INV_SUB_MIX_3[SBOX[t & 0xFF]];
            } while (n < n2);
        }
        unit = Unit.INSTANCE;
        aES.invKeySchedule = nArray;
    }

    @NotNull
    public final int[] getKeyWords() {
        return this.keyWords;
    }

    public AES(@NotNull byte[] key) {
        this(AES.Companion.toIntArray(key));
    }

    public final void encryptBlock(@NotNull int[] M, int offset) {
        this.doCryptBlock(M, offset, this.keySchedule, SUB_MIX_0, SUB_MIX_1, SUB_MIX_2, SUB_MIX_3, SBOX);
    }

    public final void decryptBlock(@NotNull int[] M, int offset) {
        int t = M[offset + 1];
        M[offset + 1] = M[offset + 3];
        M[offset + 3] = t;
        this.doCryptBlock(M, offset, this.invKeySchedule, INV_SUB_MIX_0, INV_SUB_MIX_1, INV_SUB_MIX_2, INV_SUB_MIX_3, INV_SBOX);
        t = M[offset + 1];
        M[offset + 1] = M[offset + 3];
        M[offset + 3] = t;
    }

    private final void doCryptBlock(int[] M, int offset, int[] keySchedule, int[] SUB_MIX_0, int[] SUB_MIX_1, int[] SUB_MIX_2, int[] SUB_MIX_3, int[] SBOX) {
        int $this$ext8$iv;
        int $this$ext8$iv2;
        int $this$ext8$iv3;
        int $this$ext8$iv4;
        boolean $i$f$ext8;
        int offset$iv;
        int n;
        int s0 = M[offset + 0] ^ keySchedule[0];
        int s1 = M[offset + 1] ^ keySchedule[1];
        int s2 = M[offset + 2] ^ keySchedule[2];
        int s3 = M[offset + 3] ^ keySchedule[3];
        int ksRow = 4;
        int n2 = 1;
        int n3 = this.numRounds;
        if (n2 < n3) {
            do {
                int $this$ext8$iv5;
                int $this$ext8$iv6;
                int $this$ext8$iv7;
                int round = n2++;
                n = s0;
                offset$iv = 24;
                $i$f$ext8 = false;
                int n4 = SUB_MIX_0[$this$ext8$iv4 >>> offset$iv & 0xFF];
                $this$ext8$iv4 = s1;
                offset$iv = 16;
                $i$f$ext8 = false;
                int n5 = n4 ^ SUB_MIX_1[$this$ext8$iv4 >>> offset$iv & 0xFF];
                $this$ext8$iv4 = s2;
                offset$iv = 8;
                $i$f$ext8 = false;
                int n6 = n5 ^ SUB_MIX_2[$this$ext8$iv4 >>> offset$iv & 0xFF];
                $this$ext8$iv4 = s3;
                offset$iv = 0;
                $i$f$ext8 = false;
                int n7 = n6 ^ SUB_MIX_3[$this$ext8$iv4 >>> offset$iv & 0xFF];
                $this$ext8$iv4 = ksRow;
                ksRow = $this$ext8$iv4 + 1;
                int t0 = n7 ^ keySchedule[$this$ext8$iv4];
                offset$iv = s1;
                int offset$iv2 = 24;
                boolean $i$f$ext82 = false;
                int n8 = SUB_MIX_0[$this$ext8$iv7 >>> offset$iv2 & 0xFF];
                $this$ext8$iv7 = s2;
                offset$iv2 = 16;
                $i$f$ext82 = false;
                int n9 = n8 ^ SUB_MIX_1[$this$ext8$iv7 >>> offset$iv2 & 0xFF];
                $this$ext8$iv7 = s3;
                offset$iv2 = 8;
                $i$f$ext82 = false;
                int n10 = n9 ^ SUB_MIX_2[$this$ext8$iv7 >>> offset$iv2 & 0xFF];
                $this$ext8$iv7 = s0;
                offset$iv2 = 0;
                $i$f$ext82 = false;
                int n11 = n10 ^ SUB_MIX_3[$this$ext8$iv7 >>> offset$iv2 & 0xFF];
                $this$ext8$iv7 = ksRow;
                ksRow = $this$ext8$iv7 + 1;
                int t1 = n11 ^ keySchedule[$this$ext8$iv7];
                offset$iv2 = s2;
                int offset$iv3 = 24;
                boolean $i$f$ext83 = false;
                int n12 = SUB_MIX_0[$this$ext8$iv6 >>> offset$iv3 & 0xFF];
                $this$ext8$iv6 = s3;
                offset$iv3 = 16;
                $i$f$ext83 = false;
                int n13 = n12 ^ SUB_MIX_1[$this$ext8$iv6 >>> offset$iv3 & 0xFF];
                $this$ext8$iv6 = s0;
                offset$iv3 = 8;
                $i$f$ext83 = false;
                int n14 = n13 ^ SUB_MIX_2[$this$ext8$iv6 >>> offset$iv3 & 0xFF];
                $this$ext8$iv6 = s1;
                offset$iv3 = 0;
                $i$f$ext83 = false;
                int n15 = n14 ^ SUB_MIX_3[$this$ext8$iv6 >>> offset$iv3 & 0xFF];
                $this$ext8$iv6 = ksRow;
                ksRow = $this$ext8$iv6 + 1;
                int t2 = n15 ^ keySchedule[$this$ext8$iv6];
                offset$iv3 = s3;
                int offset$iv4 = 24;
                boolean $i$f$ext84 = false;
                int n16 = SUB_MIX_0[$this$ext8$iv5 >>> offset$iv4 & 0xFF];
                $this$ext8$iv5 = s0;
                offset$iv4 = 16;
                $i$f$ext84 = false;
                int n17 = n16 ^ SUB_MIX_1[$this$ext8$iv5 >>> offset$iv4 & 0xFF];
                $this$ext8$iv5 = s1;
                offset$iv4 = 8;
                $i$f$ext84 = false;
                int n18 = n17 ^ SUB_MIX_2[$this$ext8$iv5 >>> offset$iv4 & 0xFF];
                $this$ext8$iv5 = s2;
                offset$iv4 = 0;
                $i$f$ext84 = false;
                int n19 = ksRow;
                ksRow = n19 + 1;
                int t3 = n18 ^ SUB_MIX_3[$this$ext8$iv5 >>> offset$iv4 & 0xFF] ^ keySchedule[n19];
                s0 = t0;
                s1 = t1;
                s2 = t2;
                s3 = t3;
            } while (n2 < n3);
        }
        n3 = s0;
        int offset$iv5 = 24;
        boolean $i$f$ext85 = false;
        int n20 = SBOX[$this$ext8$iv3 >>> offset$iv5 & 0xFF] << 24;
        $this$ext8$iv3 = s1;
        offset$iv5 = 16;
        $i$f$ext85 = false;
        int n21 = n20 | SBOX[$this$ext8$iv3 >>> offset$iv5 & 0xFF] << 16;
        $this$ext8$iv3 = s2;
        offset$iv5 = 8;
        $i$f$ext85 = false;
        int n22 = n21 | SBOX[$this$ext8$iv3 >>> offset$iv5 & 0xFF] << 8;
        $this$ext8$iv3 = s3;
        offset$iv5 = 0;
        $i$f$ext85 = false;
        int n23 = n22 | SBOX[$this$ext8$iv3 >>> offset$iv5 & 0xFF];
        $this$ext8$iv3 = ksRow;
        ksRow = $this$ext8$iv3 + 1;
        int t0 = n23 ^ keySchedule[$this$ext8$iv3];
        offset$iv5 = s1;
        int offset$iv6 = 24;
        boolean $i$f$ext86 = false;
        int n24 = SBOX[$this$ext8$iv2 >>> offset$iv6 & 0xFF] << 24;
        $this$ext8$iv2 = s2;
        offset$iv6 = 16;
        $i$f$ext86 = false;
        int n25 = n24 | SBOX[$this$ext8$iv2 >>> offset$iv6 & 0xFF] << 16;
        $this$ext8$iv2 = s3;
        offset$iv6 = 8;
        $i$f$ext86 = false;
        int n26 = n25 | SBOX[$this$ext8$iv2 >>> offset$iv6 & 0xFF] << 8;
        $this$ext8$iv2 = s0;
        offset$iv6 = 0;
        $i$f$ext86 = false;
        int n27 = n26 | SBOX[$this$ext8$iv2 >>> offset$iv6 & 0xFF];
        $this$ext8$iv2 = ksRow;
        ksRow = $this$ext8$iv2 + 1;
        int t1 = n27 ^ keySchedule[$this$ext8$iv2];
        offset$iv6 = s2;
        int offset$iv7 = 24;
        boolean $i$f$ext87 = false;
        int n28 = SBOX[$this$ext8$iv >>> offset$iv7 & 0xFF] << 24;
        $this$ext8$iv = s3;
        offset$iv7 = 16;
        $i$f$ext87 = false;
        int n29 = n28 | SBOX[$this$ext8$iv >>> offset$iv7 & 0xFF] << 16;
        $this$ext8$iv = s0;
        offset$iv7 = 8;
        $i$f$ext87 = false;
        int n30 = n29 | SBOX[$this$ext8$iv >>> offset$iv7 & 0xFF] << 8;
        $this$ext8$iv = s1;
        offset$iv7 = 0;
        $i$f$ext87 = false;
        int n31 = n30 | SBOX[$this$ext8$iv >>> offset$iv7 & 0xFF];
        $this$ext8$iv = ksRow;
        ksRow = $this$ext8$iv + 1;
        int t2 = n31 ^ keySchedule[$this$ext8$iv];
        offset$iv7 = s3;
        offset$iv = 24;
        $i$f$ext8 = false;
        int n32 = SBOX[$this$ext8$iv4 >>> offset$iv & 0xFF] << 24;
        $this$ext8$iv4 = s0;
        offset$iv = 16;
        $i$f$ext8 = false;
        int n33 = n32 | SBOX[$this$ext8$iv4 >>> offset$iv & 0xFF] << 16;
        $this$ext8$iv4 = s1;
        offset$iv = 8;
        $i$f$ext8 = false;
        int n34 = n33 | SBOX[$this$ext8$iv4 >>> offset$iv & 0xFF] << 8;
        $this$ext8$iv4 = s2;
        offset$iv = 0;
        $i$f$ext8 = false;
        n = ksRow;
        ksRow = n + 1;
        int t3 = (n34 | SBOX[$this$ext8$iv4 >>> offset$iv & 0xFF]) ^ keySchedule[n];
        M[offset + 0] = t0;
        M[offset + 1] = t1;
        M[offset + 2] = t2;
        M[offset + 3] = t3;
    }

    static {
        int n;
        Companion = new Companion(null);
        SBOX = new int[256];
        INV_SBOX = new int[256];
        SUB_MIX_0 = new int[256];
        SUB_MIX_1 = new int[256];
        SUB_MIX_2 = new int[256];
        SUB_MIX_3 = new int[256];
        INV_SUB_MIX_0 = new int[256];
        INV_SUB_MIX_1 = new int[256];
        INV_SUB_MIX_2 = new int[256];
        INV_SUB_MIX_3 = new int[256];
        int[] nArray = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54};
        RCON = nArray;
        int[] nArray2 = new int[256];
        for (int i = 0; i < 256; ++i) {
            n = i;
            nArray2[n] = n >= 128 ? n << 1 ^ 0x11B : n << 1;
        }
        int[] d = nArray2;
        int x = 0;
        int xi = 0;
        n = 0;
        do {
            int i = n++;
            int sx = xi ^ xi << 1 ^ xi << 2 ^ xi << 3 ^ xi << 4;
            AES.SBOX[x] = sx = sx >>> 8 ^ sx & 0xFF ^ 0x63;
            AES.INV_SBOX[sx] = x;
            int x2 = d[x];
            int x4 = d[x2];
            int x8 = d[x4];
            int t = 0;
            t = d[sx] * 257 ^ sx * 0x1010100;
            AES.SUB_MIX_0[x] = t << 24 | t >>> 8;
            AES.SUB_MIX_1[x] = t << 16 | t >>> 16;
            AES.SUB_MIX_2[x] = t << 8 | t >>> 24;
            AES.SUB_MIX_3[x] = t << 0;
            t = x8 * 0x1010101 ^ x4 * 65537 ^ x2 * 257 ^ x * 0x1010100;
            AES.INV_SUB_MIX_0[sx] = t << 24 | t >>> 8;
            AES.INV_SUB_MIX_1[sx] = t << 16 | t >>> 16;
            AES.INV_SUB_MIX_2[sx] = t << 8 | t >>> 24;
            AES.INV_SUB_MIX_3[sx] = t << 0;
            if (x == 0) {
                x = 1;
                xi = 1;
                continue;
            }
            x = x2 ^ d[d[d[x8 ^ x2]]];
            xi ^= d[d[xi]];
        } while (n < 256);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u0016J&\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J&\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J&\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J&\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u0016J&\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J&\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J&\u0010!\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J&\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010#\u001a\u00020\u00122\b\u0010$\u001a\u0004\u0018\u00010\u0012H\u0002J\f\u0010%\u001a\u00020\u0012*\u00020\u0006H\u0002J\f\u0010&\u001a\u00020\u0006*\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/soywiz/krypto/AES$Companion;", "", "()V", "BLOCK_SIZE", "", "INV_SBOX", "", "INV_SUB_MIX_0", "INV_SUB_MIX_1", "INV_SUB_MIX_2", "INV_SUB_MIX_3", "RCON", "SBOX", "SUB_MIX_0", "SUB_MIX_1", "SUB_MIX_2", "SUB_MIX_3", "decryptAes128Cbc", "", "data", "key", "padding", "Lcom/soywiz/krypto/Padding;", "decryptAesCbc", "iv", "decryptAesCfb", "decryptAesEcb", "decryptAesOfb", "decryptAesPcbc", "encryptAes128Cbc", "encryptAesCbc", "encryptAesCfb", "encryptAesEcb", "encryptAesOfb", "encryptAesPcbc", "getIV", "srcIV", "toByteArray", "toIntArray", "krypto_release"})
    public static final class Companion {
        private Companion() {
        }

        private final int[] toIntArray(byte[] $this$toIntArray) {
            int[] out = new int[$this$toIntArray.length / 4];
            int m = 0;
            int n = 0;
            int n2 = out.length;
            if (n < n2) {
                do {
                    int n3 = n++;
                    int n4 = m;
                    m = n4 + 1;
                    int v3 = $this$toIntArray[n4] & 0xFF;
                    int n5 = m;
                    m = n5 + 1;
                    int v2 = $this$toIntArray[n5] & 0xFF;
                    int n6 = m;
                    m = n6 + 1;
                    int v1 = $this$toIntArray[n6] & 0xFF;
                    int n7 = m;
                    m = n7 + 1;
                    int v0 = $this$toIntArray[n7] & 0xFF;
                    out[n3] = v0 << 0 | v1 << 8 | v2 << 16 | v3 << 24;
                } while (n < n2);
            }
            return out;
        }

        private final byte[] toByteArray(int[] $this$toByteArray) {
            byte[] out = new byte[$this$toByteArray.length * 4];
            int m = 0;
            int n = 0;
            int n2 = $this$toByteArray.length;
            if (n < n2) {
                do {
                    int n3 = n++;
                    int v = $this$toByteArray[n3];
                    int n4 = m;
                    m = n4 + 1;
                    out[n4] = (byte)(v >> 24 & 0xFF);
                    n4 = m;
                    m = n4 + 1;
                    out[n4] = (byte)(v >> 16 & 0xFF);
                    n4 = m;
                    m = n4 + 1;
                    out[n4] = (byte)(v >> 8 & 0xFF);
                    n4 = m;
                    m = n4 + 1;
                    out[n4] = (byte)(v >> 0 & 0xFF);
                } while (n < n2);
            }
            return out;
        }

        private final byte[] getIV(byte[] srcIV) {
            byte[] dstIV = new byte[16];
            byte[] byArray = srcIV;
            if (byArray != null) {
                byte[] byArray2 = byArray;
                boolean bl = false;
                boolean bl2 = false;
                byte[] $this$getIV_u24lambda_u2d0 = byArray2;
                boolean bl3 = false;
                int min = $this$getIV_u24lambda_u2d0.length < dstIV.length ? $this$getIV_u24lambda_u2d0.length : dstIV.length;
                KryptoToolsKt.arraycopy(srcIV, 0, dstIV, 0, min);
            }
            return dstIV;
        }

        @NotNull
        public final byte[] encryptAes128Cbc(@NotNull byte[] data, @NotNull byte[] key, @NotNull Padding padding) {
            return this.encryptAesCbc(data, key, new byte[16], padding);
        }

        public static /* synthetic */ byte[] encryptAes128Cbc$default(Companion companion, byte[] byArray, byte[] byArray2, Padding padding, int n, Object object) {
            if ((n & 4) != 0) {
                padding = Padding.NoPadding;
            }
            return companion.encryptAes128Cbc(byArray, byArray2, padding);
        }

        @NotNull
        public final byte[] decryptAes128Cbc(@NotNull byte[] data, @NotNull byte[] key, @NotNull Padding padding) {
            return this.decryptAesCbc(data, key, new byte[16], padding);
        }

        public static /* synthetic */ byte[] decryptAes128Cbc$default(Companion companion, byte[] byArray, byte[] byArray2, Padding padding, int n, Object object) {
            if ((n & 4) != 0) {
                padding = Padding.NoPadding;
            }
            return companion.decryptAes128Cbc(byArray, byArray2, padding);
        }

        @NotNull
        public final byte[] encryptAesEcb(@NotNull byte[] data, @NotNull byte[] key, @NotNull Padding padding) {
            byte[] pData = Padding.Companion.padding(data, 16, padding);
            AES aes = new AES(key);
            int[] words = this.toIntArray(pData);
            int wordsLength = words.length;
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)wordsLength)), (int)4);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                int n4;
                do {
                    n4 = n;
                    n += n3;
                    aes.encryptBlock(words, n4);
                } while (n4 != n2);
            }
            return this.toByteArray(words);
        }

        @NotNull
        public final byte[] decryptAesEcb(@NotNull byte[] data, @NotNull byte[] key, @NotNull Padding padding) {
            AES aes = new AES(key);
            int[] dataWords = this.toIntArray(data);
            int wordsLength = dataWords.length;
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)wordsLength)), (int)4);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                int n4;
                do {
                    n4 = n;
                    n += n3;
                    aes.decryptBlock(dataWords, n4);
                } while (n4 != n2);
            }
            return Padding.Companion.removePadding(this.toByteArray(dataWords), padding);
        }

        @NotNull
        public final byte[] encryptAesCbc(@NotNull byte[] data, @NotNull byte[] key, @NotNull byte[] iv, @NotNull Padding padding) {
            byte[] pData = Padding.Companion.padding(data, 16, padding);
            AES aes = new AES(key);
            int[] words = this.toIntArray(pData);
            int wordsLength = words.length;
            int[] ivWords = this.toIntArray(this.getIV(iv));
            int s0 = ivWords[0];
            int s1 = ivWords[1];
            int s2 = ivWords[2];
            int s3 = ivWords[3];
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)wordsLength)), (int)4);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                int n4;
                do {
                    n4 = n;
                    n += n3;
                    words[n4 + 0] = words[n4 + 0] ^ s0;
                    words[n4 + 1] = words[n4 + 1] ^ s1;
                    words[n4 + 2] = words[n4 + 2] ^ s2;
                    words[n4 + 3] = words[n4 + 3] ^ s3;
                    aes.encryptBlock(words, n4);
                    s0 = words[n4 + 0];
                    s1 = words[n4 + 1];
                    s2 = words[n4 + 2];
                    s3 = words[n4 + 3];
                } while (n4 != n2);
            }
            return this.toByteArray(words);
        }

        @NotNull
        public final byte[] decryptAesCbc(@NotNull byte[] data, @NotNull byte[] key, @NotNull byte[] iv, @NotNull Padding padding) {
            AES aes = new AES(key);
            int[] dataWords = this.toIntArray(data);
            int wordsLength = dataWords.length;
            int[] ivWords = this.toIntArray(this.getIV(iv));
            int s0 = ivWords[0];
            int s1 = ivWords[1];
            int s2 = ivWords[2];
            int s3 = ivWords[3];
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)wordsLength)), (int)4);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                int n4;
                do {
                    n4 = n;
                    n += n3;
                    int t0 = dataWords[n4 + 0];
                    int t1 = dataWords[n4 + 1];
                    int t2 = dataWords[n4 + 2];
                    int t3 = dataWords[n4 + 3];
                    aes.decryptBlock(dataWords, n4);
                    dataWords[n4 + 0] = dataWords[n4 + 0] ^ s0;
                    dataWords[n4 + 1] = dataWords[n4 + 1] ^ s1;
                    dataWords[n4 + 2] = dataWords[n4 + 2] ^ s2;
                    dataWords[n4 + 3] = dataWords[n4 + 3] ^ s3;
                    s0 = t0;
                    s1 = t1;
                    s2 = t2;
                    s3 = t3;
                } while (n4 != n2);
            }
            return Padding.Companion.removePadding(this.toByteArray(dataWords), padding);
        }

        @NotNull
        public final byte[] encryptAesPcbc(@NotNull byte[] data, @NotNull byte[] key, @NotNull byte[] iv, @NotNull Padding padding) {
            byte[] pData = Padding.Companion.padding(data, 16, padding);
            AES aes = new AES(key);
            int[] words = this.toIntArray(pData);
            int wordsLength = words.length;
            int[] ivWords = this.toIntArray(this.getIV(iv));
            int[] plaintext = new int[4];
            int s0 = ivWords[0];
            int s1 = ivWords[1];
            int s2 = ivWords[2];
            int s3 = ivWords[3];
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)wordsLength)), (int)4);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                int n4;
                do {
                    n4 = n;
                    n += n3;
                    KryptoToolsKt.arraycopy(words, n4, plaintext, 0, 4);
                    words[n4 + 0] = plaintext[0] ^ s0;
                    words[n4 + 1] = plaintext[1] ^ s1;
                    words[n4 + 2] = plaintext[2] ^ s2;
                    words[n4 + 3] = plaintext[3] ^ s3;
                    aes.encryptBlock(words, n4);
                    s0 = words[n4 + 0] ^ plaintext[0];
                    s1 = words[n4 + 1] ^ plaintext[1];
                    s2 = words[n4 + 2] ^ plaintext[2];
                    s3 = words[n4 + 3] ^ plaintext[3];
                } while (n4 != n2);
            }
            return this.toByteArray(words);
        }

        @NotNull
        public final byte[] decryptAesPcbc(@NotNull byte[] data, @NotNull byte[] key, @NotNull byte[] iv, @NotNull Padding padding) {
            AES aes = new AES(key);
            int[] dataWords = this.toIntArray(data);
            int wordsLength = dataWords.length;
            int[] ivWords = this.toIntArray(this.getIV(iv));
            int[] cipherText = new int[4];
            int s0 = ivWords[0];
            int s1 = ivWords[1];
            int s2 = ivWords[2];
            int s3 = ivWords[3];
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)wordsLength)), (int)4);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                int n4;
                do {
                    n4 = n;
                    n += n3;
                    KryptoToolsKt.arraycopy(dataWords, n4, cipherText, 0, 4);
                    aes.decryptBlock(dataWords, n4);
                    dataWords[n4 + 0] = dataWords[n4 + 0] ^ s0;
                    dataWords[n4 + 1] = dataWords[n4 + 1] ^ s1;
                    dataWords[n4 + 2] = dataWords[n4 + 2] ^ s2;
                    dataWords[n4 + 3] = dataWords[n4 + 3] ^ s3;
                    s0 = dataWords[n4 + 0] ^ cipherText[0];
                    s1 = dataWords[n4 + 1] ^ cipherText[1];
                    s2 = dataWords[n4 + 2] ^ cipherText[2];
                    s3 = dataWords[n4 + 3] ^ cipherText[3];
                } while (n4 != n2);
            }
            return Padding.Companion.removePadding(this.toByteArray(dataWords), padding);
        }

        @NotNull
        public final byte[] encryptAesCfb(@NotNull byte[] data, @NotNull byte[] key, @NotNull byte[] iv, @NotNull Padding padding) {
            byte[] wordsData;
            byte[] pData = Padding.Companion.padding(data, 16, padding);
            int dataSize = pData.length;
            if (dataSize % 16 != 0) {
                pData = Padding.Companion.padding(pData, 16, Padding.ZeroPadding);
            }
            AES aes = new AES(key);
            int[] words = this.toIntArray(pData);
            int wordsLength = words.length;
            int[] ivWords = this.toIntArray(this.getIV(iv));
            int[] cipherText = new int[4];
            aes.encryptBlock(ivWords, 0);
            KryptoToolsKt.arraycopy(ivWords, 0, cipherText, 0, 4);
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)wordsLength)), (int)4);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                int n4;
                do {
                    n4 = n;
                    n += n3;
                    cipherText[0] = cipherText[0] ^ words[n4 + 0];
                    cipherText[1] = cipherText[1] ^ words[n4 + 1];
                    cipherText[2] = cipherText[2] ^ words[n4 + 2];
                    cipherText[3] = cipherText[3] ^ words[n4 + 3];
                    KryptoToolsKt.arraycopy(cipherText, 0, words, n4, 4);
                    if (n4 + 4 >= wordsLength) continue;
                    aes.encryptBlock(cipherText, 0);
                } while (n4 != n2);
            }
            byte[] result = wordsData = this.toByteArray(words);
            if (dataSize < wordsData.length) {
                result = new byte[dataSize];
                KryptoToolsKt.arraycopy(wordsData, 0, result, 0, result.length);
            }
            return result;
        }

        @NotNull
        public final byte[] decryptAesCfb(@NotNull byte[] data, @NotNull byte[] key, @NotNull byte[] iv, @NotNull Padding padding) {
            byte[] wordsData;
            int dataSize = data.length;
            byte[] pData = data;
            if (dataSize % 16 != 0) {
                pData = Padding.Companion.padding(data, 16, Padding.ZeroPadding);
            }
            AES aes = new AES(key);
            int[] words = this.toIntArray(pData);
            int wordsLength = words.length;
            int[] ivWords = this.toIntArray(this.getIV(iv));
            int[] plainText = new int[4];
            int[] cipherText = new int[4];
            aes.encryptBlock(ivWords, 0);
            KryptoToolsKt.arraycopy(ivWords, 0, cipherText, 0, 4);
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)wordsLength)), (int)4);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                int n4;
                do {
                    n4 = n;
                    n += n3;
                    plainText[0] = cipherText[0] ^ words[n4 + 0];
                    plainText[1] = cipherText[1] ^ words[n4 + 1];
                    plainText[2] = cipherText[2] ^ words[n4 + 2];
                    plainText[3] = cipherText[3] ^ words[n4 + 3];
                    KryptoToolsKt.arraycopy(words, n4, cipherText, 0, 4);
                    KryptoToolsKt.arraycopy(plainText, 0, words, n4, 4);
                    if (n4 + 4 >= wordsLength) continue;
                    aes.encryptBlock(cipherText, 0);
                } while (n4 != n2);
            }
            byte[] result = wordsData = this.toByteArray(words);
            if (dataSize < wordsData.length) {
                result = new byte[dataSize];
                KryptoToolsKt.arraycopy(wordsData, 0, result, 0, result.length);
            }
            return Padding.Companion.removePadding(result, padding);
        }

        @NotNull
        public final byte[] encryptAesOfb(@NotNull byte[] data, @NotNull byte[] key, @NotNull byte[] iv, @NotNull Padding padding) {
            byte[] wordsData;
            byte[] pData = Padding.Companion.padding(data, 16, padding);
            int dataSize = pData.length;
            if (dataSize % 16 != 0) {
                pData = Padding.Companion.padding(pData, 16, Padding.ZeroPadding);
            }
            AES aes = new AES(key);
            int[] words = this.toIntArray(pData);
            int wordsLength = words.length;
            int[] ivWords = this.toIntArray(this.getIV(iv));
            int[] cipherText = new int[4];
            aes.encryptBlock(ivWords, 0);
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)wordsLength)), (int)4);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                int n4;
                do {
                    n4 = n;
                    n += n3;
                    cipherText[0] = ivWords[0] ^ words[n4 + 0];
                    cipherText[1] = ivWords[1] ^ words[n4 + 1];
                    cipherText[2] = ivWords[2] ^ words[n4 + 2];
                    cipherText[3] = ivWords[3] ^ words[n4 + 3];
                    KryptoToolsKt.arraycopy(cipherText, 0, words, n4, 4);
                    if (n4 + 4 >= wordsLength) continue;
                    aes.encryptBlock(ivWords, 0);
                } while (n4 != n2);
            }
            byte[] result = wordsData = this.toByteArray(words);
            if (dataSize < wordsData.length) {
                result = new byte[dataSize];
                KryptoToolsKt.arraycopy(wordsData, 0, result, 0, result.length);
            }
            return result;
        }

        @NotNull
        public final byte[] decryptAesOfb(@NotNull byte[] data, @NotNull byte[] key, @NotNull byte[] iv, @NotNull Padding padding) {
            byte[] wordsData;
            int dataSize = data.length;
            byte[] pData = data;
            if (dataSize % 16 != 0) {
                pData = Padding.Companion.padding(data, 16, Padding.ZeroPadding);
            }
            AES aes = new AES(key);
            int[] words = this.toIntArray(pData);
            int wordsLength = words.length;
            int[] ivWords = this.toIntArray(this.getIV(iv));
            int[] plainText = new int[4];
            aes.encryptBlock(ivWords, 0);
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)wordsLength)), (int)4);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                int n4;
                do {
                    n4 = n;
                    n += n3;
                    plainText[0] = ivWords[0] ^ words[n4 + 0];
                    plainText[1] = ivWords[1] ^ words[n4 + 1];
                    plainText[2] = ivWords[2] ^ words[n4 + 2];
                    plainText[3] = ivWords[3] ^ words[n4 + 3];
                    KryptoToolsKt.arraycopy(plainText, 0, words, n4, 4);
                    if (n4 + 4 >= wordsLength) continue;
                    aes.encryptBlock(ivWords, 0);
                } while (n4 != n2);
            }
            byte[] result = wordsData = this.toByteArray(words);
            if (dataSize < wordsData.length) {
                result = new byte[dataSize];
                KryptoToolsKt.arraycopy(wordsData, 0, result, 0, result.length);
            }
            return Padding.Companion.removePadding(result, padding);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

