/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.Window;
import com.squareup.leakcanary.objectwatcher.core.R;
import curtains.Curtains;
import curtains.OnRootViewAddedListener;
import curtains.WindowsKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.InstallableWatcher;
import leakcanary.ReachabilityWatcher;
import leakcanary.RootViewWatcher;
import leakcanary.RootViewWatcher$WhenMappings;
import leakcanary.internal.HandlersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lleakcanary/RootViewWatcher;", "Lleakcanary/InstallableWatcher;", "reachabilityWatcher", "Lleakcanary/ReachabilityWatcher;", "(Lleakcanary/ReachabilityWatcher;)V", "listener", "Lcurtains/OnRootViewAddedListener;", "install", "", "uninstall", "leakcanary-object-watcher-android-core_release"})
public final class RootViewWatcher
implements InstallableWatcher {
    private final OnRootViewAddedListener listener;
    private final ReachabilityWatcher reachabilityWatcher;

    @Override
    public void install() {
        Collection collection = Curtains.getOnRootViewsChangedListeners();
        OnRootViewAddedListener onRootViewAddedListener = this.listener;
        boolean bl = false;
        collection.add(onRootViewAddedListener);
    }

    @Override
    public void uninstall() {
        Collection collection = Curtains.getOnRootViewsChangedListeners();
        OnRootViewAddedListener onRootViewAddedListener = this.listener;
        boolean bl = false;
        collection.remove(onRootViewAddedListener);
    }

    public RootViewWatcher(@NotNull ReachabilityWatcher reachabilityWatcher) {
        Intrinsics.checkParameterIsNotNull((Object)reachabilityWatcher, (String)"reachabilityWatcher");
        this.reachabilityWatcher = reachabilityWatcher;
        this.listener = new OnRootViewAddedListener(this){
            final /* synthetic */ RootViewWatcher this$0;

            public final void onRootViewAdded(@NotNull View rootView) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)rootView, (String)"rootView");
                switch (RootViewWatcher$WhenMappings.$EnumSwitchMapping$0[WindowsKt.getWindowType((View)rootView).ordinal()]) {
                    case 1: {
                        Window.Callback callback;
                        Window window = WindowsKt.getPhoneWindow((View)rootView);
                        Window.Callback callback2 = window != null && (window = window.getCallback()) != null ? WindowsKt.getWrappedCallback((Window.Callback)window) : (callback = null);
                        if (callback instanceof Activity) {
                            bl = false;
                            break;
                        }
                        if (callback instanceof Dialog) {
                            Context context = rootView.getContext();
                            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"rootView.context");
                            Context context2 = context.getApplicationContext();
                            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"rootView.context.applicationContext");
                            Resources resources = context2.getResources();
                            bl = resources.getBoolean(R.bool.leak_canary_watcher_watch_dismissed_dialogs);
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 2: {
                        bl = false;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        bl = true;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                boolean trackDetached = bl;
                if (trackDetached) {
                    rootView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(this, rootView){
                        @NotNull
                        private final Runnable watchDetachedView;
                        final /* synthetic */ listener.1 this$0;
                        final /* synthetic */ View $rootView;

                        @NotNull
                        public final Runnable getWatchDetachedView() {
                            return this.watchDetachedView;
                        }

                        public void onViewAttachedToWindow(@NotNull View v) {
                            Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
                            boolean $i$f$getMainHandler = false;
                            HandlersKt.getMainHandler().removeCallbacks(this.watchDetachedView);
                        }

                        public void onViewDetachedFromWindow(@NotNull View v) {
                            Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
                            boolean $i$f$getMainHandler = false;
                            HandlersKt.getMainHandler().post(this.watchDetachedView);
                        }
                        {
                            this.this$0 = this$0;
                            this.$rootView = $captured_local_variable$1;
                            this.watchDetachedView = new Runnable(this){
                                final /* synthetic */ listener.1 this$0;

                                public final void run() {
                                    RootViewWatcher.access$getReachabilityWatcher$p(this.this$0.this$0.this$0).expectWeaklyReachable((Object)this.this$0.$rootView, this.this$0.$rootView.getClass().getName() + " received View#onDetachedFromWindow() callback");
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            };
                        }
                    });
                }
            }

            public void onRootViewsChanged(@NotNull View view, boolean added) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                OnRootViewAddedListener.DefaultImpls.onRootViewsChanged((OnRootViewAddedListener)this, (View)view, (boolean)added);
            }
            {
                this.this$0 = rootViewWatcher;
            }
        };
    }

    public static final /* synthetic */ ReachabilityWatcher access$getReachabilityWatcher$p(RootViewWatcher $this) {
        return $this.reachabilityWatcher;
    }
}

