/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.leakcanary.DebuggerControl;
import com.squareup.leakcanary.GcTrigger;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.HeapDumper;
import com.squareup.leakcanary.KeyedWeakReference;
import com.squareup.leakcanary.Preconditions;
import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public final class RefWatcher {
    public static final RefWatcher DISABLED = new RefWatcher(new Executor(){

        @Override
        public void execute(Runnable command) {
        }
    }, new DebuggerControl(){

        @Override
        public boolean isDebuggerAttached() {
            return true;
        }
    }, GcTrigger.DEFAULT, new HeapDumper(){

        @Override
        public File dumpHeap() {
            return null;
        }
    }, new HeapDump.Listener(){

        @Override
        public void analyze(HeapDump heapDump) {
        }
    });
    private final Executor watchExecutor;
    private final DebuggerControl debuggerControl;
    private final GcTrigger gcTrigger;
    private final HeapDumper heapDumper;
    private final Set<String> retainedKeys;
    private final ReferenceQueue<Object> queue;
    private final HeapDump.Listener heapdumpListener;

    public RefWatcher(Executor watchExecutor, DebuggerControl debuggerControl, GcTrigger gcTrigger, HeapDumper heapDumper, HeapDump.Listener heapdumpListener) {
        this.watchExecutor = Preconditions.checkNotNull(watchExecutor, "watchExecutor");
        this.debuggerControl = Preconditions.checkNotNull(debuggerControl, "debuggerControl");
        this.gcTrigger = Preconditions.checkNotNull(gcTrigger, "gcTrigger");
        this.heapDumper = Preconditions.checkNotNull(heapDumper, "heapDumper");
        this.heapdumpListener = Preconditions.checkNotNull(heapdumpListener, "heapdumpListener");
        this.retainedKeys = new CopyOnWriteArraySet<String>();
        this.queue = new ReferenceQueue();
    }

    public void watch(Object watchedReference) {
        this.watch(watchedReference, "");
    }

    public void watch(Object watchedReference, String referenceName) {
        Preconditions.checkNotNull(watchedReference, "watchedReference");
        Preconditions.checkNotNull(referenceName, "referenceName");
        if (this.debuggerControl.isDebuggerAttached()) {
            return;
        }
        final long watchStartNanoTime = System.nanoTime();
        String key = UUID.randomUUID().toString();
        this.retainedKeys.add(key);
        final KeyedWeakReference reference = new KeyedWeakReference(watchedReference, key, referenceName, this.queue);
        this.watchExecutor.execute(new Runnable(){

            @Override
            public void run() {
                RefWatcher.this.ensureGone(reference, watchStartNanoTime);
            }
        });
    }

    void ensureGone(KeyedWeakReference reference, long watchStartNanoTime) {
        long gcStartNanoTime = System.nanoTime();
        long watchDurationMs = TimeUnit.NANOSECONDS.toMillis(gcStartNanoTime - watchStartNanoTime);
        this.removeWeaklyReachableReferences();
        if (this.gone(reference) || this.debuggerControl.isDebuggerAttached()) {
            return;
        }
        this.gcTrigger.runGc();
        this.removeWeaklyReachableReferences();
        if (!this.gone(reference)) {
            long startDumpHeap = System.nanoTime();
            long gcDurationMs = TimeUnit.NANOSECONDS.toMillis(startDumpHeap - gcStartNanoTime);
            File heapDumpFile = this.heapDumper.dumpHeap();
            if (heapDumpFile == null) {
                return;
            }
            long heapDumpDurationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startDumpHeap);
            this.heapdumpListener.analyze(new HeapDump(heapDumpFile, reference.key, reference.name, watchDurationMs, gcDurationMs, heapDumpDurationMs));
        }
    }

    private boolean gone(KeyedWeakReference reference) {
        return !this.retainedKeys.contains(reference.key);
    }

    private void removeWeaklyReachableReferences() {
        KeyedWeakReference ref;
        while ((ref = (KeyedWeakReference)this.queue.poll()) != null) {
            this.retainedKeys.remove(ref.key);
        }
    }
}

