/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.leakcanary.DebuggerControl;
import com.squareup.leakcanary.ExcludedRefs;
import com.squareup.leakcanary.GcTrigger;
import com.squareup.leakcanary.HeapDump;
import com.squareup.leakcanary.HeapDumper;
import com.squareup.leakcanary.KeyedWeakReference;
import com.squareup.leakcanary.Preconditions;
import com.squareup.leakcanary.RefWatcherBuilder;
import com.squareup.leakcanary.Retryable;
import com.squareup.leakcanary.WatchExecutor;
import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;

public final class RefWatcher {
    public static final RefWatcher DISABLED = new RefWatcherBuilder().build();
    private final WatchExecutor watchExecutor;
    private final DebuggerControl debuggerControl;
    private final GcTrigger gcTrigger;
    private final HeapDumper heapDumper;
    private final Set<String> retainedKeys;
    private final ReferenceQueue<Object> queue;
    private final HeapDump.Listener heapdumpListener;
    private final ExcludedRefs excludedRefs;

    RefWatcher(WatchExecutor watchExecutor, DebuggerControl debuggerControl, GcTrigger gcTrigger, HeapDumper heapDumper, HeapDump.Listener heapdumpListener, ExcludedRefs excludedRefs) {
        this.watchExecutor = Preconditions.checkNotNull(watchExecutor, "watchExecutor");
        this.debuggerControl = Preconditions.checkNotNull(debuggerControl, "debuggerControl");
        this.gcTrigger = Preconditions.checkNotNull(gcTrigger, "gcTrigger");
        this.heapDumper = Preconditions.checkNotNull(heapDumper, "heapDumper");
        this.heapdumpListener = Preconditions.checkNotNull(heapdumpListener, "heapdumpListener");
        this.excludedRefs = Preconditions.checkNotNull(excludedRefs, "excludedRefs");
        this.retainedKeys = new CopyOnWriteArraySet<String>();
        this.queue = new ReferenceQueue();
    }

    public void watch(Object watchedReference) {
        this.watch(watchedReference, "");
    }

    public void watch(Object watchedReference, String referenceName) {
        if (this == DISABLED) {
            return;
        }
        Preconditions.checkNotNull(watchedReference, "watchedReference");
        Preconditions.checkNotNull(referenceName, "referenceName");
        long watchStartNanoTime = System.nanoTime();
        String key = UUID.randomUUID().toString();
        this.retainedKeys.add(key);
        KeyedWeakReference reference = new KeyedWeakReference(watchedReference, key, referenceName, this.queue);
        this.ensureGoneAsync(watchStartNanoTime, reference);
    }

    private void ensureGoneAsync(final long watchStartNanoTime, final KeyedWeakReference reference) {
        this.watchExecutor.execute(new Retryable(){

            @Override
            public Retryable.Result run() {
                return RefWatcher.this.ensureGone(reference, watchStartNanoTime);
            }
        });
    }

    Retryable.Result ensureGone(KeyedWeakReference reference, long watchStartNanoTime) {
        long gcStartNanoTime = System.nanoTime();
        long watchDurationMs = TimeUnit.NANOSECONDS.toMillis(gcStartNanoTime - watchStartNanoTime);
        this.removeWeaklyReachableReferences();
        if (this.debuggerControl.isDebuggerAttached()) {
            return Retryable.Result.RETRY;
        }
        if (this.gone(reference)) {
            return Retryable.Result.DONE;
        }
        this.gcTrigger.runGc();
        this.removeWeaklyReachableReferences();
        if (!this.gone(reference)) {
            long startDumpHeap = System.nanoTime();
            long gcDurationMs = TimeUnit.NANOSECONDS.toMillis(startDumpHeap - gcStartNanoTime);
            File heapDumpFile = this.heapDumper.dumpHeap();
            if (heapDumpFile == HeapDumper.RETRY_LATER) {
                return Retryable.Result.RETRY;
            }
            long heapDumpDurationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startDumpHeap);
            this.heapdumpListener.analyze(new HeapDump(heapDumpFile, reference.key, reference.name, this.excludedRefs, watchDurationMs, gcDurationMs, heapDumpDurationMs));
        }
        return Retryable.Result.DONE;
    }

    private boolean gone(KeyedWeakReference reference) {
        return !this.retainedKeys.contains(reference.key);
    }

    private void removeWeaklyReachableReferences() {
        KeyedWeakReference ref;
        while ((ref = (KeyedWeakReference)this.queue.poll()) != null) {
            this.retainedKeys.remove(ref.key);
        }
    }
}

