/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.CanaryLog;
import leakcanary.Clock;
import leakcanary.KeyedWeakReference;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u001c\u001a\u00020\bJ\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\u0014\u0010\u001f\u001a\u00020\b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\b\u0010!\u001a\u00020\bH\u0002J\u000e\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u0001J\u0016\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lleakcanary/RefWatcher;", "", "clock", "Lleakcanary/Clock;", "checkRetainedExecutor", "Ljava/util/concurrent/Executor;", "onReferenceRetained", "Lkotlin/Function0;", "", "isEnabled", "", "(Lleakcanary/Clock;Ljava/util/concurrent/Executor;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "hasRetainedReferences", "getHasRetainedReferences", "()Z", "hasWatchedReferences", "getHasWatchedReferences", "queue", "Ljava/lang/ref/ReferenceQueue;", "retainedKeys", "", "", "getRetainedKeys", "()Ljava/util/Set;", "retainedReferences", "", "Lleakcanary/KeyedWeakReference;", "watchedReferences", "clearWatchedReferences", "moveToRetained", "key", "removeRetainedKeys", "keysToRemove", "removeWeaklyReachableReferences", "watch", "watchedReference", "referenceName", "leakcanary-watcher"})
public final class RefWatcher {
    private final Map<String, KeyedWeakReference> watchedReferences;
    private final Map<String, KeyedWeakReference> retainedReferences;
    private final ReferenceQueue<Object> queue;
    private final Clock clock;
    private final Executor checkRetainedExecutor;
    private final Function0<Unit> onReferenceRetained;
    private final Function0<Boolean> isEnabled;

    public final synchronized boolean getHasRetainedReferences() {
        this.removeWeaklyReachableReferences();
        Map<String, KeyedWeakReference> map = this.retainedReferences;
        return !map.isEmpty();
    }

    public final synchronized boolean getHasWatchedReferences() {
        this.removeWeaklyReachableReferences();
        Map<String, KeyedWeakReference> map = this.retainedReferences;
        return !map.isEmpty() || !(map = this.watchedReferences).isEmpty();
    }

    @NotNull
    public final synchronized Set<String> getRetainedKeys() {
        this.removeWeaklyReachableReferences();
        return new HashSet(this.retainedReferences.keySet());
    }

    public final synchronized void watch(@NotNull Object watchedReference) {
        Intrinsics.checkParameterIsNotNull((Object)watchedReference, (String)"watchedReference");
        this.watch(watchedReference, "");
    }

    public final synchronized void watch(@NotNull Object watchedReference, @NotNull String referenceName) {
        Intrinsics.checkParameterIsNotNull((Object)watchedReference, (String)"watchedReference");
        Intrinsics.checkParameterIsNotNull((Object)referenceName, (String)"referenceName");
        if (!((Boolean)this.isEnabled.invoke()).booleanValue()) {
            return;
        }
        this.removeWeaklyReachableReferences();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID()\n        .toString()");
        String key = string;
        long watchUptimeMillis = this.clock.uptimeMillis();
        KeyedWeakReference reference = new KeyedWeakReference(watchedReference, key, referenceName, watchUptimeMillis, this.queue);
        if (Intrinsics.areEqual((Object)referenceName, (Object)"") ^ true) {
            CanaryLog.INSTANCE.d("Watching instance of %s named %s with key %s", new Object[]{reference.getClassName(), referenceName, key});
        } else {
            CanaryLog.INSTANCE.d("Watching instance of %s with key %s", new Object[]{reference.getClassName(), key});
        }
        Map<String, KeyedWeakReference> map = this.watchedReferences;
        KeyedWeakReference keyedWeakReference = reference;
        map.put(key, keyedWeakReference);
        this.checkRetainedExecutor.execute(new Runnable(this, key){
            final /* synthetic */ RefWatcher this$0;
            final /* synthetic */ String $key;

            public final void run() {
                RefWatcher.access$moveToRetained(this.this$0, this.$key);
            }
            {
                this.this$0 = refWatcher;
                this.$key = string;
            }
        });
    }

    private final synchronized void moveToRetained(String key) {
        this.removeWeaklyReachableReferences();
        KeyedWeakReference retainedRef = this.watchedReferences.remove(key);
        if (retainedRef != null) {
            Map<String, KeyedWeakReference> map = this.retainedReferences;
            KeyedWeakReference keyedWeakReference = retainedRef;
            map.put(key, keyedWeakReference);
            this.onReferenceRetained.invoke();
        }
    }

    public final synchronized void removeRetainedKeys(@NotNull Set<String> keysToRemove) {
        Intrinsics.checkParameterIsNotNull(keysToRemove, (String)"keysToRemove");
        this.retainedReferences.keySet().removeAll((Collection)keysToRemove);
    }

    public final synchronized void clearWatchedReferences() {
        this.watchedReferences.clear();
        this.retainedReferences.clear();
    }

    private final void removeWeaklyReachableReferences() {
        KeyedWeakReference ref = null;
        do {
            KeyedWeakReference removedRef;
            if ((ref = (KeyedWeakReference)this.queue.poll()) == null || (removedRef = this.watchedReferences.remove(ref.getKey())) != null) continue;
            this.retainedReferences.remove(ref.getKey());
        } while (ref != null);
    }

    public RefWatcher(@NotNull Clock clock, @NotNull Executor checkRetainedExecutor, @NotNull Function0<Unit> onReferenceRetained, @NotNull Function0<Boolean> isEnabled) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        Intrinsics.checkParameterIsNotNull((Object)checkRetainedExecutor, (String)"checkRetainedExecutor");
        Intrinsics.checkParameterIsNotNull(onReferenceRetained, (String)"onReferenceRetained");
        Intrinsics.checkParameterIsNotNull(isEnabled, (String)"isEnabled");
        this.clock = clock;
        this.checkRetainedExecutor = checkRetainedExecutor;
        this.onReferenceRetained = onReferenceRetained;
        this.isEnabled = isEnabled;
        RefWatcher refWatcher = this;
        refWatcher.watchedReferences = map = (Map)new LinkedHashMap();
        refWatcher = this;
        refWatcher.retainedReferences = map = (Map)new LinkedHashMap();
        this.queue = new ReferenceQueue();
    }

    public /* synthetic */ RefWatcher(Clock clock, Executor executor, Function0 function0, Function0 function02, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function02 = 1.INSTANCE;
        }
        this(clock, executor, (Function0<Unit>)function0, (Function0<Boolean>)function02);
    }

    public static final /* synthetic */ void access$moveToRetained(RefWatcher $this, String key) {
        $this.moveToRetained(key);
    }
}

