/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.dnsoverhttps;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dns;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.dnsoverhttps.BootstrapDns;
import okhttp3.dnsoverhttps.DnsRecordCodec;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 +2\u00020\u0001:\u0002*+B7\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002JF\u0010\u000f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J>\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0\u0017H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u0010H\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J8\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0\u0017H\u0002J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\"H\u0002J(\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0\u001fH\u0002R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\fR\u0013\u0010\u0006\u001a\u00020\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\rR\u0013\u0010\b\u001a\u00020\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\rR\u0013\u0010\t\u001a\u00020\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\rR\u0013\u0010\n\u001a\u00020\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\rR\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000e\u00a8\u0006,"}, d2={"Lokhttp3/dnsoverhttps/DnsOverHttps;", "Lokhttp3/Dns;", "client", "Lokhttp3/OkHttpClient;", "url", "Lokhttp3/HttpUrl;", "includeIPv6", "", "post", "resolvePrivateAddresses", "resolvePublicAddresses", "(Lokhttp3/OkHttpClient;Lokhttp3/HttpUrl;ZZZZ)V", "()Lokhttp3/OkHttpClient;", "()Z", "()Lokhttp3/HttpUrl;", "buildRequest", "Lokhttp3/Request;", "hostname", "", "type", "", "", "networkRequests", "", "Lokhttp3/Call;", "results", "Ljava/net/InetAddress;", "failures", "Ljava/lang/Exception;", "Lkotlin/Exception;", "executeRequests", "", "responses", "getCacheOnlyResponse", "Lokhttp3/Response;", "request", "lookup", "lookupHttps", "processResponse", "response", "readResponse", "throwBestFailure", "Builder", "Companion", "okhttp-dnsoverhttps"})
public final class DnsOverHttps
implements Dns {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final HttpUrl url;
    private final boolean includeIPv6;
    private final boolean post;
    private final boolean resolvePrivateAddresses;
    private final boolean resolvePublicAddresses;
    @NotNull
    private static final MediaType DNS_MESSAGE = MediaType.Companion.get("application/dns-message");
    public static final int MAX_RESPONSE_SIZE = 65536;

    public DnsOverHttps(@NotNull OkHttpClient client, @NotNull HttpUrl url, boolean includeIPv6, boolean post, boolean resolvePrivateAddresses, boolean resolvePublicAddresses) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.client = client;
        this.url = url;
        this.includeIPv6 = includeIPv6;
        this.post = post;
        this.resolvePrivateAddresses = resolvePrivateAddresses;
        this.resolvePublicAddresses = resolvePublicAddresses;
    }

    @JvmName(name="client")
    @NotNull
    public final OkHttpClient client() {
        return this.client;
    }

    @JvmName(name="url")
    @NotNull
    public final HttpUrl url() {
        return this.url;
    }

    @JvmName(name="includeIPv6")
    public final boolean includeIPv6() {
        return this.includeIPv6;
    }

    @JvmName(name="post")
    public final boolean post() {
        return this.post;
    }

    @JvmName(name="resolvePrivateAddresses")
    public final boolean resolvePrivateAddresses() {
        return this.resolvePrivateAddresses;
    }

    @JvmName(name="resolvePublicAddresses")
    public final boolean resolvePublicAddresses() {
        return this.resolvePublicAddresses;
    }

    @NotNull
    public List<InetAddress> lookup(@NotNull String hostname) throws UnknownHostException {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        if (!this.resolvePrivateAddresses || !this.resolvePublicAddresses) {
            boolean privateHost = Companion.isPrivateHost$okhttp_dnsoverhttps(hostname);
            if (privateHost && !this.resolvePrivateAddresses) {
                throw new UnknownHostException("private hosts not resolved");
            }
            if (!privateHost && !this.resolvePublicAddresses) {
                throw new UnknownHostException("public hosts not resolved");
            }
        }
        return this.lookupHttps(hostname);
    }

    private final List<InetAddress> lookupHttps(String hostname) throws UnknownHostException {
        List<InetAddress> list;
        ArrayList networkRequests = new ArrayList(2);
        ArrayList failures = new ArrayList(2);
        ArrayList results = new ArrayList(5);
        this.buildRequest(hostname, networkRequests, results, failures, 1);
        if (this.includeIPv6) {
            this.buildRequest(hostname, networkRequests, results, failures, 28);
        }
        this.executeRequests(hostname, networkRequests, results, failures);
        List<InetAddress> list2 = results;
        if (list2.isEmpty()) {
            boolean bl = false;
            list = this.throwBestFailure(hostname, failures);
        } else {
            list = list2;
        }
        return list;
    }

    private final void buildRequest(String hostname, List<Call> networkRequests, List<InetAddress> results, List<Exception> failures, int type) {
        Response response;
        Request request = this.buildRequest(hostname, type);
        Response response2 = response = this.getCacheOnlyResponse(request);
        if (response2 != null) {
            Response it = response2;
            boolean bl = false;
            this.processResponse(it, hostname, results, failures);
        } else {
            networkRequests.add(this.client.newCall(request));
        }
    }

    private final void executeRequests(String hostname, List<? extends Call> networkRequests, List<InetAddress> responses, List<Exception> failures) {
        CountDownLatch latch = new CountDownLatch(networkRequests.size());
        for (Call call : networkRequests) {
            call.enqueue(new Callback(failures, latch, this, hostname, responses){
                final /* synthetic */ List<Exception> $failures;
                final /* synthetic */ CountDownLatch $latch;
                final /* synthetic */ DnsOverHttps this$0;
                final /* synthetic */ String $hostname;
                final /* synthetic */ List<InetAddress> $responses;
                {
                    this.$failures = $failures;
                    this.$latch = $latch;
                    this.this$0 = $receiver;
                    this.$hostname = $hostname;
                    this.$responses = $responses;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(@NotNull Call call, @NotNull IOException e) {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    List<Exception> list = this.$failures;
                    List<Exception> list2 = this.$failures;
                    List<Exception> list3 = list;
                    synchronized (list3) {
                        boolean bl = false;
                        boolean bl2 = list2.add(e);
                    }
                    this.$latch.countDown();
                }

                public void onResponse(@NotNull Call call, @NotNull Response response) {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    DnsOverHttps.access$processResponse(this.this$0, response, this.$hostname, this.$responses, this.$failures);
                    this.$latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            failures.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processResponse(Response response, String hostname, List<InetAddress> results, List<Exception> failures) {
        try {
            List<InetAddress> addresses = this.readResponse(hostname, response);
            List<InetAddress> list = results;
            synchronized (list) {
                boolean bl = false;
                bl = results.addAll((Collection<InetAddress>)addresses);
            }
        }
        catch (Exception e) {
            List<Exception> list = failures;
            synchronized (list) {
                boolean bl = false;
                boolean bl2 = failures.add(e);
            }
        }
    }

    private final List<InetAddress> throwBestFailure(String hostname, List<? extends Exception> failures) throws UnknownHostException {
        if (failures.isEmpty()) {
            throw new UnknownHostException(hostname);
        }
        Exception failure = failures.get(0);
        if (failure instanceof UnknownHostException) {
            throw failure;
        }
        UnknownHostException unknownHostException = new UnknownHostException(hostname);
        unknownHostException.initCause(failure);
        int n = failures.size();
        for (int i = 1; i < n; ++i) {
            ExceptionsKt.addSuppressed((Throwable)unknownHostException, (Throwable)failures.get(i));
        }
        throw unknownHostException;
    }

    private final Response getCacheOnlyResponse(Request request) {
        if (!this.post && this.client.cache() != null) {
            try {
                CacheControl preferCache = new CacheControl.Builder().onlyIfCached().build();
                Request cacheRequest = request.newBuilder().cacheControl(preferCache).build();
                Response cacheResponse = this.client.newCall(cacheRequest).execute();
                if (cacheResponse.code() != 504) {
                    return cacheResponse;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<InetAddress> readResponse(String hostname, Response response) throws Exception {
        if (response.cacheResponse() == null && response.protocol() != Protocol.HTTP_2) {
            Platform.log$default((Platform)Platform.Companion.get(), (String)("Incorrect protocol: " + response.protocol()), (int)5, null, (int)4, null);
        }
        Closeable closeable = (Closeable)response;
        Throwable throwable = null;
        try {
            ResponseBody body;
            Response it = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new IOException("response: " + response.code() + ' ' + response.message());
            }
            ResponseBody responseBody = body = response.body();
            Intrinsics.checkNotNull((Object)responseBody);
            if (responseBody.contentLength() > 65536L) {
                throw new IOException("response size exceeds limit (65536 bytes): " + body.contentLength() + " bytes");
            }
            ByteString responseBytes = body.source().readByteString();
            List<InetAddress> list = DnsRecordCodec.INSTANCE.decodeAnswers(hostname, responseBytes);
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Request buildRequest(String hostname, int type) {
        Request.Builder builder;
        Request.Builder $this$buildRequest_u24lambda_u2d5 = builder = new Request.Builder().header("Accept", DNS_MESSAGE.toString());
        boolean bl = false;
        ByteString query = DnsRecordCodec.INSTANCE.encodeQuery(hostname, type);
        if (this.post) {
            $this$buildRequest_u24lambda_u2d5.url(this.url).post(RequestBody.Companion.create(query, DNS_MESSAGE));
        } else {
            String encoded = StringsKt.replace$default((String)query.base64Url(), (String)"=", (String)"", (boolean)false, (int)4, null);
            HttpUrl requestUrl = this.url.newBuilder().addQueryParameter("dns", encoded).build();
            $this$buildRequest_u24lambda_u2d5.url(requestUrl);
        }
        return builder.build();
    }

    public static final /* synthetic */ void access$processResponse(DnsOverHttps $this, Response response, String hostname, List results, List failures) {
        $this.processResponse(response, hostname, results, failures);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00002\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050+\"\u00020\u0005\u00a2\u0006\u0002\u0010,J\u0016\u0010\u0003\u001a\u00020\u00002\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004J\u0006\u0010-\u001a\u00020.J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0011J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0011J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0011J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&R\"\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\u001a\u0010\u001c\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R\u001a\u0010\u001f\u001a\u00020 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006/"}, d2={"Lokhttp3/dnsoverhttps/DnsOverHttps$Builder;", "", "()V", "bootstrapDnsHosts", "", "Ljava/net/InetAddress;", "getBootstrapDnsHosts$okhttp_dnsoverhttps", "()Ljava/util/List;", "setBootstrapDnsHosts$okhttp_dnsoverhttps", "(Ljava/util/List;)V", "client", "Lokhttp3/OkHttpClient;", "getClient$okhttp_dnsoverhttps", "()Lokhttp3/OkHttpClient;", "setClient$okhttp_dnsoverhttps", "(Lokhttp3/OkHttpClient;)V", "includeIPv6", "", "getIncludeIPv6$okhttp_dnsoverhttps", "()Z", "setIncludeIPv6$okhttp_dnsoverhttps", "(Z)V", "post", "getPost$okhttp_dnsoverhttps", "setPost$okhttp_dnsoverhttps", "resolvePrivateAddresses", "getResolvePrivateAddresses$okhttp_dnsoverhttps", "setResolvePrivateAddresses$okhttp_dnsoverhttps", "resolvePublicAddresses", "getResolvePublicAddresses$okhttp_dnsoverhttps", "setResolvePublicAddresses$okhttp_dnsoverhttps", "systemDns", "Lokhttp3/Dns;", "getSystemDns$okhttp_dnsoverhttps", "()Lokhttp3/Dns;", "setSystemDns$okhttp_dnsoverhttps", "(Lokhttp3/Dns;)V", "url", "Lokhttp3/HttpUrl;", "getUrl$okhttp_dnsoverhttps", "()Lokhttp3/HttpUrl;", "setUrl$okhttp_dnsoverhttps", "(Lokhttp3/HttpUrl;)V", "", "([Ljava/net/InetAddress;)Lokhttp3/dnsoverhttps/DnsOverHttps$Builder;", "build", "Lokhttp3/dnsoverhttps/DnsOverHttps;", "okhttp-dnsoverhttps"})
    public static final class Builder {
        @Nullable
        private OkHttpClient client;
        @Nullable
        private HttpUrl url;
        private boolean includeIPv6 = true;
        private boolean post;
        @NotNull
        private Dns systemDns = Dns.SYSTEM;
        @Nullable
        private List<? extends InetAddress> bootstrapDnsHosts;
        private boolean resolvePrivateAddresses;
        private boolean resolvePublicAddresses = true;

        @Nullable
        public final OkHttpClient getClient$okhttp_dnsoverhttps() {
            return this.client;
        }

        public final void setClient$okhttp_dnsoverhttps(@Nullable OkHttpClient okHttpClient) {
            this.client = okHttpClient;
        }

        @Nullable
        public final HttpUrl getUrl$okhttp_dnsoverhttps() {
            return this.url;
        }

        public final void setUrl$okhttp_dnsoverhttps(@Nullable HttpUrl httpUrl) {
            this.url = httpUrl;
        }

        public final boolean getIncludeIPv6$okhttp_dnsoverhttps() {
            return this.includeIPv6;
        }

        public final void setIncludeIPv6$okhttp_dnsoverhttps(boolean bl) {
            this.includeIPv6 = bl;
        }

        public final boolean getPost$okhttp_dnsoverhttps() {
            return this.post;
        }

        public final void setPost$okhttp_dnsoverhttps(boolean bl) {
            this.post = bl;
        }

        @NotNull
        public final Dns getSystemDns$okhttp_dnsoverhttps() {
            return this.systemDns;
        }

        public final void setSystemDns$okhttp_dnsoverhttps(@NotNull Dns dns) {
            Intrinsics.checkNotNullParameter((Object)dns, (String)"<set-?>");
            this.systemDns = dns;
        }

        @Nullable
        public final List<InetAddress> getBootstrapDnsHosts$okhttp_dnsoverhttps() {
            return this.bootstrapDnsHosts;
        }

        public final void setBootstrapDnsHosts$okhttp_dnsoverhttps(@Nullable List<? extends InetAddress> list) {
            this.bootstrapDnsHosts = list;
        }

        public final boolean getResolvePrivateAddresses$okhttp_dnsoverhttps() {
            return this.resolvePrivateAddresses;
        }

        public final void setResolvePrivateAddresses$okhttp_dnsoverhttps(boolean bl) {
            this.resolvePrivateAddresses = bl;
        }

        public final boolean getResolvePublicAddresses$okhttp_dnsoverhttps() {
            return this.resolvePublicAddresses;
        }

        public final void setResolvePublicAddresses$okhttp_dnsoverhttps(boolean bl) {
            this.resolvePublicAddresses = bl;
        }

        @NotNull
        public final DnsOverHttps build() {
            OkHttpClient okHttpClient = this.client;
            if (okHttpClient == null) {
                throw new NullPointerException("client not set");
            }
            OkHttpClient client = okHttpClient;
            OkHttpClient okHttpClient2 = client.newBuilder().dns(Companion.buildBootstrapClient(this)).build();
            HttpUrl httpUrl = this.url;
            if (httpUrl == null) {
                OkHttpClient okHttpClient3 = okHttpClient2;
                boolean bl = false;
                OkHttpClient okHttpClient4 = okHttpClient3;
                String string = "url not set";
                throw new IllegalStateException(string.toString());
            }
            boolean bl = this.resolvePublicAddresses;
            boolean bl2 = this.resolvePrivateAddresses;
            boolean bl3 = this.post;
            boolean bl4 = this.includeIPv6;
            HttpUrl httpUrl2 = httpUrl;
            OkHttpClient okHttpClient5 = okHttpClient2;
            return new DnsOverHttps(okHttpClient5, httpUrl2, bl4, bl3, bl2, bl);
        }

        @NotNull
        public final Builder client(@NotNull OkHttpClient client) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Builder $this$client_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$client_u24lambda_u2d1.client = client;
            return builder;
        }

        @NotNull
        public final Builder url(@NotNull HttpUrl url) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Builder $this$url_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$url_u24lambda_u2d2.url = url;
            return builder;
        }

        @NotNull
        public final Builder includeIPv6(boolean includeIPv6) {
            Builder builder;
            Builder $this$includeIPv6_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$includeIPv6_u24lambda_u2d3.includeIPv6 = includeIPv6;
            return builder;
        }

        @NotNull
        public final Builder post(boolean post) {
            Builder builder;
            Builder $this$post_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$post_u24lambda_u2d4.post = post;
            return builder;
        }

        @NotNull
        public final Builder resolvePrivateAddresses(boolean resolvePrivateAddresses) {
            Builder builder;
            Builder $this$resolvePrivateAddresses_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            $this$resolvePrivateAddresses_u24lambda_u2d5.resolvePrivateAddresses = resolvePrivateAddresses;
            return builder;
        }

        @NotNull
        public final Builder resolvePublicAddresses(boolean resolvePublicAddresses) {
            Builder builder;
            Builder $this$resolvePublicAddresses_u24lambda_u2d6 = builder = this;
            boolean bl = false;
            $this$resolvePublicAddresses_u24lambda_u2d6.resolvePublicAddresses = resolvePublicAddresses;
            return builder;
        }

        @NotNull
        public final Builder bootstrapDnsHosts(@Nullable List<? extends InetAddress> bootstrapDnsHosts) {
            Builder builder;
            Builder $this$bootstrapDnsHosts_u24lambda_u2d7 = builder = this;
            boolean bl = false;
            $this$bootstrapDnsHosts_u24lambda_u2d7.bootstrapDnsHosts = bootstrapDnsHosts;
            return builder;
        }

        @NotNull
        public final Builder bootstrapDnsHosts(InetAddress ... bootstrapDnsHosts) {
            Intrinsics.checkNotNullParameter((Object)bootstrapDnsHosts, (String)"bootstrapDnsHosts");
            return this.bootstrapDnsHosts(ArraysKt.toList((Object[])bootstrapDnsHosts));
        }

        @NotNull
        public final Builder systemDns(@NotNull Dns systemDns) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)systemDns, (String)"systemDns");
            Builder $this$systemDns_u24lambda_u2d8 = builder = this;
            boolean bl = false;
            $this$systemDns_u24lambda_u2d8.systemDns = systemDns;
            return builder;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lokhttp3/dnsoverhttps/DnsOverHttps$Companion;", "", "()V", "DNS_MESSAGE", "Lokhttp3/MediaType;", "getDNS_MESSAGE", "()Lokhttp3/MediaType;", "MAX_RESPONSE_SIZE", "", "buildBootstrapClient", "Lokhttp3/Dns;", "builder", "Lokhttp3/dnsoverhttps/DnsOverHttps$Builder;", "isPrivateHost", "", "host", "", "isPrivateHost$okhttp_dnsoverhttps", "okhttp-dnsoverhttps"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MediaType getDNS_MESSAGE() {
            return DNS_MESSAGE;
        }

        private final Dns buildBootstrapClient(Builder builder) {
            Dns dns;
            List<InetAddress> hosts = builder.getBootstrapDnsHosts$okhttp_dnsoverhttps();
            if (hosts != null) {
                HttpUrl httpUrl = builder.getUrl$okhttp_dnsoverhttps();
                Intrinsics.checkNotNull((Object)httpUrl);
                dns = new BootstrapDns(httpUrl.host(), hosts);
            } else {
                dns = builder.getSystemDns$okhttp_dnsoverhttps();
            }
            return dns;
        }

        public final boolean isPrivateHost$okhttp_dnsoverhttps(@NotNull String host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return PublicSuffixDatabase.Companion.get().getEffectiveTldPlusOne(host) == null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

