package com.talpa.adsilence.data;

import android.os.Parcel;
import android.os.Parcelable;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import androidx.annotation.IntDef;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringDef;

/**
 * 作为输出的 展示物料 数据结构
 *
 * @author 💎 Li Junchao
 */
public class DisplayMaterial implements Parcelable
{
    public static final int SCENE_SPLASH = 1;
    public static final int SCENE_RESULR = 0;

    @Documented
    @Retention(RetentionPolicy.SOURCE)
    @Target({ElementType.LOCAL_VARIABLE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    @IntDef({SCENE_SPLASH, SCENE_RESULR})
    public @interface Scene {}

    public static final String TYPE_CHARGE = "hitop";
    public static final String TYPE_BROWSER = "hibrower";
    public static final String TYPE_XSHARE = "xshare";
    public static final String TYPE_TRANSLATE = "hitranslate";

    @Documented
    @Retention(RetentionPolicy.SOURCE)
    @Target({ElementType.FIELD, ElementType.METHOD, ElementType.LOCAL_VARIABLE, ElementType.PARAMETER})
    @StringDef({TYPE_CHARGE, TYPE_BROWSER, TYPE_XSHARE, TYPE_TRANSLATE})
    public @interface MaterialType {}

    @Nullable public String id;
    /** 物料 类型 */
    @MaterialType public String type;
    /** 标题 */
    public int title;
    /** 描述 */
    public int desc;
    public int btnTxt;
    /** app name */
    public int appname;
    public int image;
    public int icon;
    public int bg;
    public int banner_bg;
    public String link;
    @Nullable public String url;
    public int minVCode;
    public int maxVCode;
    @Nullable public String packageName;

    public DisplayMaterial() {}

    protected DisplayMaterial(Parcel in)
    {
        id = in.readString();
        type = in.readString();
        title = in.readInt();
        desc = in.readInt();
        btnTxt = in.readInt();
        appname = in.readInt();
        image = in.readInt();
        icon = in.readInt();
        bg = in.readInt();
        banner_bg = in.readInt();
        link = in.readString();
        url = in.readString();
        minVCode = in.readInt();
        maxVCode = in.readInt();
        packageName = in.readString();
    }

    public static final Creator<DisplayMaterial> CREATOR = new Creator<DisplayMaterial>()
    {
        @Override
        public DisplayMaterial createFromParcel(Parcel in)
        {
            return new DisplayMaterial(in);
        }

        @Override
        public DisplayMaterial[] newArray(int size)
        {
            return new DisplayMaterial[size];
        }
    };

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        dest.writeString(id);
        dest.writeString(type);
        dest.writeInt(title);
        dest.writeInt(desc);
        dest.writeInt(btnTxt);
        dest.writeInt(appname);
        dest.writeInt(image);
        dest.writeInt(icon);
        dest.writeInt(bg);
        dest.writeInt(banner_bg);
        dest.writeString(link);
        dest.writeString(url);
        dest.writeInt(minVCode);
        dest.writeInt(maxVCode);
        dest.writeString(packageName);
    }

    @Override
    @NonNull
    public String toString()
    {
        final StringBuilder sb = new StringBuilder("DisplayMaterial{");
        sb.append("id='").append(id).append('\'');
        sb.append(", type='").append(type).append('\'');
        sb.append(", title=").append(title);
        sb.append(", desc=").append(desc);
        sb.append(", btnTxt=").append(btnTxt);
        sb.append(", appname=").append(appname);
        sb.append(", image=").append(image);
        sb.append(", icon=").append(icon);
        sb.append(", bg=").append(bg);
        sb.append(", banner_bg=").append(banner_bg);
        sb.append(", link='").append(link).append('\'');
        sb.append(", url='").append(url).append('\'');
        sb.append(", minVCode=").append(minVCode);
        sb.append(", maxVCode=").append(maxVCode);
        sb.append(", packageName='").append(packageName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
