/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.common;

import android.os.SystemClock;
import com.talpa.common.LogUtil;
import com.talpa.common.WrapRunnable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CommonThreadPoolExecutor
extends ThreadPoolExecutor {
    private Map<Runnable, Long> map;
    private final boolean longTask;
    private final String taskTag;
    private static boolean isDebug;
    private Map<Runnable, WrapRunnable> runnableMap;

    public CommonThreadPoolExecutor(boolean longTask, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory factory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, factory);
        this.longTask = longTask;
        String string = this.taskTag = longTask ? "LongTaskExecutor" : "ShortTaskExecutor";
        if (isDebug) {
            this.map = new ConcurrentHashMap<Runnable, Long>();
            this.runnableMap = new ConcurrentHashMap<Runnable, WrapRunnable>();
        }
        this.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                super.rejectedExecution(r, e);
                LogUtil.e(CommonThreadPoolExecutor.this.taskTag, "rejectedExecution: Task " + r.toString() + " rejected from " + e.toString());
                if (isDebug) {
                    CommonThreadPoolExecutor.this.map.remove(r);
                    CommonThreadPoolExecutor.this.runnableMap.remove(r);
                }
                if (r instanceof FutureTask) {
                    try {
                        FutureTask futureTask = (FutureTask)r;
                        if (!futureTask.isCancelled() && !futureTask.isDone()) {
                            futureTask.cancel(false);
                        }
                    }
                    catch (Throwable ex) {
                        LogUtil.e(CommonThreadPoolExecutor.this.taskTag, "rejectedExecution: futureTask err " + ex);
                    }
                }
            }
        });
    }

    public static void setDebug(boolean debug) {
        isDebug = debug;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (isDebug) {
            Long time = this.map.get(r);
            if (null != time) {
                time = SystemClock.elapsedRealtime() - time;
                if (this.longTask && time > 20000L) {
                    LogUtil.e(this.taskTag, "afterExecute r " + r + " ,t " + time);
                } else if (!this.longTask && time > 5000L) {
                    LogUtil.e(this.taskTag, "afterExecute r " + r + " ,t " + time);
                } else if (time > 3000L) {
                    LogUtil.i(this.taskTag, "afterExecute r " + r + " ,t " + time);
                }
            }
            this.map.remove(r);
            this.runnableMap.remove(r);
        }
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        if (isDebug) {
            this.map.put(r, SystemClock.elapsedRealtime());
        }
    }

    @Override
    public void shutdown() {
        if (isDebug) {
            this.map.clear();
            this.runnableMap.clear();
        }
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (isDebug) {
            this.map.clear();
            this.runnableMap.clear();
        }
        return super.shutdownNow();
    }

    @Override
    protected void terminated() {
        super.terminated();
        if (isDebug) {
            this.map.clear();
            this.runnableMap.clear();
        }
    }

    @Override
    public <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return super.newTaskFor(callable);
    }

    @Override
    public <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return super.newTaskFor(runnable, value);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return super.invokeAll(tasks);
    }

    @Override
    public void execute(Runnable command) {
        if (isDebug) {
            WrapRunnable wrapRunnable = new WrapRunnable(command);
            this.runnableMap.put(command, wrapRunnable);
            super.execute(wrapRunnable);
        } else {
            super.execute(command);
        }
    }

    @Override
    public boolean remove(Runnable r) {
        if (isDebug) {
            this.map.remove(r);
            WrapRunnable wrapRunnable = this.runnableMap.get(r);
            this.runnableMap.remove(r);
            return super.remove(wrapRunnable);
        }
        return super.remove(r);
    }
}

