/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.common;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.MessageQueue;
import com.talpa.common.CommonThreadPoolExecutor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadUtil {
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = Math.max(2, Math.min(CPU_COUNT - 1, 4));
    private static final int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
    public static final int MAXIMUM_BLOCK_QUEUE_SIZE = 128;
    private static final Looper sMainLooper = Looper.getMainLooper();
    private static final Handler sHandler = new Handler(sMainLooper);
    private static Handler sWorkThreadHandler;
    private static HandlerThread sSingletonHandlerThread;
    private static ThreadPoolExecutor sExecutorPool;
    private static ThreadPoolExecutor sShortTaskPool;
    private static final ThreadFactory sThreadFactory;
    private static final ThreadFactory sLongTaskThreadFactory;

    public static synchronized ThreadPoolExecutor obtainShortTaskExecutor() {
        if (sShortTaskPool == null) {
            sShortTaskPool = new CommonThreadPoolExecutor(false, CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), sThreadFactory);
        }
        return sShortTaskPool;
    }

    public static synchronized ThreadPoolExecutor obtainLongTaskExecutor() {
        if (sExecutorPool == null) {
            sExecutorPool = new CommonThreadPoolExecutor(true, CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), sLongTaskThreadFactory);
        }
        return sExecutorPool;
    }

    private static synchronized HandlerThread getSingletonHandlerThread() {
        if (sSingletonHandlerThread == null) {
            sSingletonHandlerThread = new HandlerThread("GlobalSingletonHandlerThread");
            sSingletonHandlerThread.start();
        }
        return sSingletonHandlerThread;
    }

    private static synchronized Handler getWorkThreadHandler() {
        if (sWorkThreadHandler == null) {
            sWorkThreadHandler = new Handler(ThreadUtil.getSingletonHandlerThread().getLooper());
        }
        return sWorkThreadHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasSingletonHandlerThread() {
        Class<ThreadUtil> clazz = ThreadUtil.class;
        synchronized (ThreadUtil.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sSingletonHandlerThread != null;
        }
    }

    public static void runOnMainThread(Runnable command, long delayed) {
        sHandler.postDelayed(command, delayed);
    }

    public static void runOnMainThread(Runnable command) {
        if (Thread.currentThread() == sMainLooper.getThread()) {
            command.run();
        } else {
            sHandler.post(command);
        }
    }

    public static void runShortTaskOnBackground(Runnable command) {
        try {
            ThreadUtil.obtainShortTaskExecutor().execute(command);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void runShortTaskOnBackgroundDelay(Runnable command, long delay) {
        if (delay <= 0L) {
            ThreadUtil.runShortTaskOnBackground(command);
        } else {
            ThreadUtil.getWorkThreadHandler().postDelayed(command, delay);
        }
    }

    public static void runLongTaskOnBackground(Runnable command) {
        ThreadUtil.obtainLongTaskExecutor().execute(command);
    }

    public static void removeDelayTask(Runnable command) {
        if (command == null) {
            return;
        }
        if (ThreadUtil.hasSingletonHandlerThread()) {
            ThreadUtil.getWorkThreadHandler().removeCallbacks(command);
        }
    }

    private static void removeRunnable(Runnable launchContinuation) {
        sHandler.removeCallbacks(launchContinuation);
    }

    private static void removeBackLong(Runnable r) {
        try {
            ThreadUtil.obtainLongTaskExecutor().remove(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void removeBackShort(Runnable r) {
        try {
            ThreadUtil.obtainShortTaskExecutor().remove(r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void addIdleRunnable(final Runnable runnable) {
        if (runnable == null) {
            return;
        }
        ThreadUtil.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

                    public boolean queueIdle() {
                        runnable.run();
                        return false;
                    }
                });
            }
        });
    }

    private static void addIdleRunnable(final Runnable runnable, long delay) {
        if (runnable == null) {
            return;
        }
        ThreadUtil.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

                    public boolean queueIdle() {
                        runnable.run();
                        return false;
                    }
                });
            }
        }, delay);
    }

    static {
        sThreadFactory = new ThreadFactory(){
            private final AtomicInteger mCount = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "shortTask #" + this.mCount.getAndIncrement());
            }
        };
        sLongTaskThreadFactory = new ThreadFactory(){
            private final AtomicInteger mCount = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "LongTask #" + this.mCount.getAndIncrement());
            }
        };
    }
}

