/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.common;

import a.b;
import a.c;
import a.d;
import a.f;
import a.h;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadUtil {
    private static final int CPU_COUNT;
    private static final int CORE_POOL_SIZE;
    private static final int MAXIMUM_POOL_SIZE;
    public static final int MAXIMUM_BLOCK_QUEUE_SIZE = 128;
    private static final Looper sMainLooper;
    private static final Handler sHandler;
    private static Handler sWorkThreadHandler;
    private static HandlerThread sSingletonHandlerThread;
    private static ThreadPoolExecutor sExecutorPool;
    private static ThreadPoolExecutor sShortTaskPool;
    private static final ThreadFactory sThreadFactory;
    private static final ThreadFactory sLongTaskThreadFactory;

    public static synchronized ThreadPoolExecutor obtainShortTaskExecutor() {
        if (sShortTaskPool == null) {
            LinkedBlockingQueue linkedBlockingQueue;
            int n = MAXIMUM_POOL_SIZE;
            TimeUnit timeUnit = TimeUnit.SECONDS;
            LinkedBlockingQueue linkedBlockingQueue2 = linkedBlockingQueue;
            linkedBlockingQueue = new LinkedBlockingQueue(128);
            ThreadFactory threadFactory = sThreadFactory;
            sShortTaskPool = new b(false, CORE_POOL_SIZE, n, timeUnit, linkedBlockingQueue2, threadFactory);
        }
        return sShortTaskPool;
    }

    public static synchronized ThreadPoolExecutor obtainLongTaskExecutor() {
        if (sExecutorPool == null) {
            LinkedBlockingQueue linkedBlockingQueue;
            int n = MAXIMUM_POOL_SIZE;
            TimeUnit timeUnit = TimeUnit.SECONDS;
            LinkedBlockingQueue linkedBlockingQueue2 = linkedBlockingQueue;
            linkedBlockingQueue = new LinkedBlockingQueue(128);
            ThreadFactory threadFactory = sLongTaskThreadFactory;
            sExecutorPool = new b(true, CORE_POOL_SIZE, n, timeUnit, linkedBlockingQueue2, threadFactory);
        }
        return sExecutorPool;
    }

    private static synchronized HandlerThread getSingletonHandlerThread() {
        if (sSingletonHandlerThread == null) {
            sSingletonHandlerThread = new HandlerThread("GlobalSingletonHandlerThread");
            sSingletonHandlerThread.start();
        }
        return sSingletonHandlerThread;
    }

    private static synchronized Handler getWorkThreadHandler() {
        if (sWorkThreadHandler == null) {
            sWorkThreadHandler = new Handler(ThreadUtil.getSingletonHandlerThread().getLooper());
        }
        return sWorkThreadHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasSingletonHandlerThread() {
        Class<ThreadUtil> clazz = ThreadUtil.class;
        synchronized (ThreadUtil.class) {
            boolean bl = sSingletonHandlerThread != null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return bl;
        }
    }

    public static void runOnMainThread(Runnable runnable, long l) {
        sHandler.postDelayed(runnable, l);
    }

    public static void runOnMainThread(Runnable runnable) {
        if (Thread.currentThread() == sMainLooper.getThread()) {
            runnable.run();
        } else {
            sHandler.post(runnable);
        }
    }

    public static void runShortTaskOnBackground(Runnable runnable) {
        try {
            ThreadUtil.obtainShortTaskExecutor().execute(runnable);
        }
        catch (Throwable throwable) {}
    }

    public static void runShortTaskOnBackgroundDelay(Runnable runnable, long l) {
        if (l <= 0L) {
            ThreadUtil.runShortTaskOnBackground(runnable);
        } else {
            ThreadUtil.getWorkThreadHandler().postDelayed(runnable, l);
        }
    }

    public static void runLongTaskOnBackground(Runnable runnable) {
        ThreadUtil.obtainLongTaskExecutor().execute(runnable);
    }

    public static void removeDelayTask(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (ThreadUtil.hasSingletonHandlerThread()) {
            ThreadUtil.getWorkThreadHandler().removeCallbacks(runnable);
        }
    }

    private static void removeRunnable(Runnable runnable) {
        sHandler.removeCallbacks(runnable);
    }

    private static void removeBackLong(Runnable runnable) {
        try {
            ThreadUtil.obtainLongTaskExecutor().remove(runnable);
        }
        catch (Throwable throwable) {}
    }

    private static void removeBackShort(Runnable runnable) {
        try {
            ThreadUtil.obtainShortTaskExecutor().remove(runnable);
        }
        catch (Throwable throwable) {}
    }

    private static void addIdleRunnable(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        ThreadUtil.runOnMainThread(new f(runnable));
    }

    private static void addIdleRunnable(Runnable runnable, long l) {
        if (runnable == null) {
            return;
        }
        ThreadUtil.runOnMainThread(new h(runnable), l);
    }

    static {
        Looper looper;
        CPU_COUNT = Runtime.getRuntime().availableProcessors();
        CORE_POOL_SIZE = Math.max(2, Math.min(CPU_COUNT - 1, 4));
        MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
        sMainLooper = looper = Looper.getMainLooper();
        sHandler = new Handler(looper);
        sThreadFactory = new c();
        sLongTaskThreadFactory = new d();
    }
}

