package com.talpa.master

import android.app.Application
import android.content.Context
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.talpa.master.framework.RoomHelper
import com.talpa.master.repository.room.model.LanguageModel
import com.talpa.master.translate.TranslateService

import io.reactivex.exceptions.UndeliverableException
import io.reactivex.plugins.RxJavaPlugins
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch
import java.io.IOException
import java.io.InputStreamReader
import java.net.SocketException

/**
 * Create by kgxl on 2021/4/2
 */
class TranslateApplication : Application() {
    companion object {
        lateinit var mApplicationContext: Context
    }

    override fun onCreate() {
        super.onCreate()
        mApplicationContext = this
        errorHandle()
        RoomHelper.init(this)
        TranslateService.getInstance().init(this)
        insertData()
    }

    private fun errorHandle() {
        RxJavaPlugins.setErrorHandler { e ->

            if (e is UndeliverableException) {
            }
            if ((e is IOException) || (e is SocketException)) {
                // fine, irrelevant network problem or API that throws on cancellation
            }
            if (e is InterruptedException) {
                // fine, some blocking code was interrupted by a dispose call
            }
            if ((e is NullPointerException) || (e is IllegalArgumentException)) {
                // that's likely a bug in the application
                //                Thread.currentThread().getUncaughtExceptionHandler()
                //                    .handleException(Thread.currentThread(), e);
                //                return;
            }
            if (e is IllegalStateException) {
                // that's a bug in RxJava or in a custom operator
                //                Thread.currentThread().getUncaughtExceptionHandler()
                //                    .handleException(Thread.currentThread(), e);
            }
            e.printStackTrace()
        }
    }

    /**
     * 初始化数据库，并插入数据
     */
    private fun insertData() {

        GlobalScope.launch {

            val dao = RoomHelper.appDao

            val supportLang = assets.open("collo_support_languages.json")
            val supportLangIsr = InputStreamReader(supportLang)

            val supportLangType = object : TypeToken<List<LanguageModel.LanguageList>>() {}.type

            val languages = Gson().fromJson<List<LanguageModel.LanguageList>>(supportLangIsr, supportLangType)

            supportLangIsr.close()
            supportLang.close()

            val flowable = dao.queryLanguage()
            val localLanguages = flowable.blockingFirst()

            val newLanguage =
                languages.filter { lang1 -> localLanguages.find { lang2 -> lang1.key == lang2.key } == null }
            dao.insertLanguage(newLanguage)
        }
    }
}