package com.talpa.master.common

import android.content.Context
import android.media.MediaPlayer
import android.net.Uri
import java.io.File

/**
 * @author CY 19-2-21
 */
object MediaPlayerHelper {

    private var mediaPlayer: MediaPlayer? = null

    fun playMusic(
        context: Context,
        path: String,
        onCompletionListener: MediaPlayer.OnCompletionListener?,
        onErrorListener: MediaPlayer.OnErrorListener?
    ) {
        mediaPlayer = MediaPlayer.create(context, Uri.fromFile(File(path)))
        if (mediaPlayer != null) {
            mediaPlayer!!.setOnCompletionListener(onCompletionListener)
            mediaPlayer!!.setOnErrorListener(onErrorListener)
            mediaPlayer?.start()
        }


    }

    fun stopMusic() {
        if (mediaPlayer?.isPlaying == true) {
            mediaPlayer?.stop()
            mediaPlayer?.release()
        }
        mediaPlayer = null
    }
}