package com.talpa.master.databinding

import android.os.Bundle
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import com.talpa.master.framework.BaseActivity

/**
 *
 * @author CY 2018/11/30
 */
abstract class DataBindingActivity<VDB : ViewDataBinding> : BaseActivity() {

    abstract fun getContentView(): Int

    val mBinding: VDB by lazy {
        DataBindingUtil.setContentView<VDB>(this, getContentView())
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mBinding.lifecycleOwner = this
        initView()
        init()
    }

    abstract fun initView()

    abstract fun init()
}