package com.talpa.master.databinding

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import androidx.fragment.app.DialogFragment
import androidx.fragment.app.FragmentManager

/**
 *
 * @author CY 2018/11/30
 */
abstract class DataBindingDialogFragment<VDB : ViewDataBinding> : DialogFragment() {

    abstract fun getContentView(): Int

    lateinit var mBinding: VDB

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        mBinding = DataBindingUtil.inflate(inflater, getContentView(), container, false)
        mBinding.setLifecycleOwner(this)
        return mBinding.root
    }

//    override fun show(manager: FragmentManager, tag: String?) {
//        //super.show(manager, tag)
//        //super.show(manager, tag)
//        mDismissed = false
//        mShownByMe = true
//
//        val ft = manager.beginTransaction()
//        ft.add(this, tag)
//        ft.commit()
//    }

    override fun show(manager: FragmentManager, tag: String?) {
        try {
            super.show(manager, tag)
        } catch (e: Throwable) {
            e.printStackTrace()
        }

    }

}