package com.talpa.master.databinding

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import com.talpa.master.framework.BaseFragment

/**
 *
 * @author CY 2018/11/30
 */
abstract class DataBindingFragment<VDB : ViewDataBinding> : BaseFragment() {

    abstract fun getContentView(): Int

    lateinit var mBinding: VDB

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        mBinding = DataBindingUtil.inflate(inflater, getContentView(), container, false)
        mBinding.lifecycleOwner = this
        return mBinding.root
    }
}