package com.talpa.master.framework

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Context
import android.content.pm.PackageManager
import android.graphics.drawable.Drawable
import android.os.Build
import android.os.Bundle
import android.os.PersistableBundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat
import com.google.android.material.snackbar.Snackbar

/**
 * Activity 基类
 * @author CY 2018/11/30
 */
@SuppressLint("Registered")
open class BaseActivity : AppCompatActivity() {

    val statusBar = Runnable {


//        window.decorView.systemUiVisibility = when {
//            Build.VERSION.SDK_INT >= Build.VERSION_CODES.M -> {
//                when (this.javaClass.name) {
//                    SplashActivity::class.java.name -> {
//                        View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
//                    }
//                    else -> {
//                        View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN //or View.SYSTEM_UI_FLAG_FULLSCREEN
//                    }
//                }
//            }
//            Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP -> {
//                View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
//            }
//            else -> {
//                View.SYSTEM_UI_FLAG_LOW_PROFILE or
//                        View.SYSTEM_UI_FLAG_FULLSCREEN or
//                        View.SYSTEM_UI_FLAG_LAYOUT_STABLE or
//                        View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY or
//                        View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION or
//                        View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
//            }
//        }

    }

    val statusBarHeight by lazy { statusBarHeight() }

    /**
     * 配置，防止文字大小跟随系统
     */
    override fun attachBaseContext(newBase: Context?) {
        val config = newBase?.resources?.configuration
        config?.fontScale = 1f
        super.attachBaseContext(newBase)
    }

    override fun onCreate(savedInstanceState: Bundle?, persistentState: PersistableBundle?) {
        super.onCreate(savedInstanceState, persistentState)

    }

    fun showSnackBar(view: View, resId : Int) {
        Snackbar.make(view, resId, Snackbar.LENGTH_SHORT).show()
    }

    fun showSnackBar(view: View, str : String) {
        Snackbar.make(view, str, Snackbar.LENGTH_SHORT).show()
    }
}

/**
 * 状态栏样式改变
 */
fun Activity.lightStatusBar(light: Boolean) {


    val flag = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
        if (light) View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN or
                View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR
        else View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
    } else {
        View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
    }

    window.decorView.systemUiVisibility = flag
}

/**
 * 状态栏高度
 */
fun Activity.statusBarHeight(): Int {
    val id = resources.getIdentifier("status_bar_height", "dimen", "android")
    return resources.getDimension(id).toInt()
}

//fun Activity.Screen(){
//    displayMetrics.widthPixels
//}

fun Context.getDrawableFromAsset(name: String): Drawable {

    val inputStream = assets.open(name)//"flag/Flag_阿拉伯.webp"
    val drawable = Drawable.createFromStream(inputStream, null)
    inputStream.close()
    return drawable
}


/**
 * 权限扩展
 */
fun Activity.checkPermission(permission: String) =
    ActivityCompat.checkSelfPermission(this, permission) == PackageManager.PERMISSION_GRANTED

