package com.talpa.master.framework

import androidx.lifecycle.MutableLiveData
import io.reactivex.Flowable
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.Disposable
import io.reactivex.schedulers.Schedulers

/**
 * 数据仓库基类，数据提供方
 * @author CY 2018/11/30
 */
open class Repository {

    fun <T> request(liveData: MutableLiveData<Resource<T>>, flowable: Flowable<T>): Disposable {

        return flowable.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe({
            liveData.value = Resource.success(it)
        }, {
            liveData.value = Resource.throwable(it)
        })

    }
}


/**
 * 数据与状态类
 * @author CY 2018/12/5
 */
data class Resource<T>(val status: Status, val any: T? = null, val throwable: Throwable? = null) {

    companion object {
        fun <T> success(any: T) = Resource(status = Status.SUCCESS, any = any)
        fun <T> throwable(throwable: Throwable) = Resource<T>(status = Status.THROWABLE, throwable = throwable)
    }
}

enum class Status {
    SUCCESS,
    THROWABLE
}