package com.talpa.master.framework

import android.app.Application
import androidx.room.Room
import androidx.room.migration.Migration
import androidx.sqlite.db.SupportSQLiteDatabase
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.talpa.master.TranslateApplication
import com.talpa.master.repository.AppDatabase
import com.talpa.master.repository.room.model.LanguageModel
import java.io.InputStreamReader

/**
 * Create by kgxl on 2021/4/2
 */
object RoomHelper {

    private lateinit var mApplication: Application

    private val appDatabase by lazy {
        Room.databaseBuilder(
            mApplication,
            AppDatabase::class.java,
            "master"
        )
            .fallbackToDestructiveMigration()
            .build()

    }

    val appDao by lazy { appDatabase.appDao() }
    val historyDao by lazy { appDatabase.historyDao() }

    fun init(application: Application) {
        mApplication = application
    }

    val MIGRATION_11_12: Migration = object : Migration(11, 12) {
        override fun migrate(database: SupportSQLiteDatabase) {
            val dao = appDao
            val supportLang =
                TranslateApplication.mApplicationContext.assets.open("collo_support_languages.json")
            val supportLangIsr = InputStreamReader(supportLang)

            val supportLangType = object : TypeToken<List<LanguageModel.LanguageList>>() {}.type

            val languages =
                Gson().fromJson<List<LanguageModel.LanguageList>>(supportLangIsr, supportLangType)

            supportLangIsr.close()
            supportLang.close()
            dao.updateLanguage(languages)
        }
    }
}