package com.talpa.master.repository

import androidx.annotation.Keep
import androidx.room.Database
import androidx.room.RoomDatabase
import com.talpa.master.repository.room.model.History
import com.talpa.master.repository.room.model.LanguageModel
import com.talpa.master.repository.room.model.TranslateLanguage
import com.talpa.master.repository.room.dao.AppDao
import com.talpa.master.repository.room.dao.HistoryDao

@Database(
    entities =
    [LanguageModel.LanguageList::class,
        TranslateLanguage::class,
        History::class],
    version = 1,exportSchema = false
)
@Keep
abstract class AppDatabase : RoomDatabase() {
    abstract fun appDao(): AppDao
    abstract fun historyDao(): HistoryDao


}