package com.talpa.master.repository

import androidx.lifecycle.MutableLiveData
import com.talpa.master.framework.RoomHelper
import com.talpa.master.repository.net.RequestHelper
import com.talpa.master.repository.room.model.LanguageModel
import com.talpa.master.framework.Repository
import com.talpa.master.framework.Resource
import io.reactivex.schedulers.Schedulers

/**
 * Create by  on 2021/4/2
 */
class MainRepository : Repository() {

    /**
     * 请求谷歌翻译
     */
    fun requestGoogleTranslate(liveData: MutableLiveData<Resource<String>>, text: String, targetLanguage: String) {
        val observable = RequestHelper.googleTranslate(text, targetLanguage).map { jsonArray ->
            //        val jsonArray = resource.any
            val ja = jsonArray[0].asJsonArray[0].asJsonArray
            val text1 = ja[0].asString//译文
            val text2 = ja[1].asString//原文
            text1
        }
        request(liveData, observable)
    }

    fun getLocalAllLanguage(liveData: MutableLiveData<List<LanguageModel.LanguageList>>, lang: LanguageModel.LanguageList?) {
        RoomHelper.appDao.queryLanguage().map {
            it.filter { inner->
                inner.key != lang?.key
            }
        }.subscribeOn(Schedulers.io()).subscribe {
            liveData.postValue(it)
        }
    }

}