package com.talpa.master.repository

import android.app.AppOpsManager
import android.app.NotificationChannel
import android.app.NotificationManager
import android.app.PendingIntent
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.net.ConnectivityManager
import android.net.NetworkInfo
import android.net.Uri
import android.os.Build
import android.preference.PreferenceManager
import android.provider.Settings
import android.text.TextUtils
import android.widget.RemoteViews
import androidx.core.app.NotificationCompat
import androidx.core.app.NotificationManagerCompat
import androidx.lifecycle.MutableLiveData
import com.cy.sts.common.Logcat
import com.talpa.master.R
import com.talpa.master.ui.main.CommunicationActivity
import java.util.*

class NotificationReceiver(private val networkLiveData: MutableLiveData<Boolean>? = null) : BroadcastReceiver() {

    companion object {
        const val ACTION_NOTIFICATION = "com.transsion.master.receiver.NOTIFICATION"
        //通知id
        const val NOTIFY_ID = 0x01
    }

    override fun onReceive(context: Context, intent: Intent) {


        when (intent.action) {
            ACTION_NOTIFICATION -> {
                val notify =
                    PreferenceManager
                        .getDefaultSharedPreferences(context)
                        .getBoolean("notify_preference", true)
                if (notify) {

                    sendNotification(context)

                } else {
                    removeNotification(context)
                }
            }
            ConnectivityManager.CONNECTIVITY_ACTION -> {
                val connectivityManager = context.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager

                val activeNetworkInfo = connectivityManager.activeNetworkInfo

                val noConnectivity = intent.getBooleanExtra(ConnectivityManager.EXTRA_NO_CONNECTIVITY, false)

                val networkType = intent.getIntExtra(ConnectivityManager.EXTRA_NETWORK_TYPE, 0)
                val networkInfo = intent.getParcelableExtra<NetworkInfo>(ConnectivityManager.EXTRA_NETWORK_INFO)

                Logcat.d(msg = "noConnectivity=$noConnectivity  networkType=$networkType  networkInfo=$networkInfo  activeNetworkInfo=$activeNetworkInfo")
                networkLiveData?.value = !noConnectivity
            }
            Intent.ACTION_LOCALE_CHANGED -> {


                val local = Locale.getDefault()
                // Toast.makeText(context, "local:${local.toLanguageTag()}", Toast.LENGTH_SHORT).show()
            }
        }

    }


    /**
     * 发送通知
     */
    private fun sendNotification(context: Context) {
        val channelId = "my_channel_01"// The id of the channel.
        //https://developer.android.google.cn/guide/topics/ui/notifiers/notifications?hl=zh-cn

        val remoteViews = RemoteViews(context.packageName, R.layout.layout_notification)

        val builder = NotificationCompat
            .Builder(context, channelId)
            .setAutoCancel(false)
            .setContentTitle("HaHa")
            .setContentText("Content")
            .setSmallIcon(R.mipmap.ic_launcher)
            .setOngoing(true)
            .setTicker("Ticker")
            .setCustomContentView(remoteViews)
            .setPriority(NotificationManagerCompat.IMPORTANCE_LOW)


        val intent = Intent(context, CommunicationActivity::class.java)
        val pendingIntent = PendingIntent.getActivity(
            context, 100, intent, PendingIntent.FLAG_UPDATE_CURRENT
        )

        builder.setContentIntent(pendingIntent)


        val nm = context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val channel = NotificationChannel(channelId, "channel", NotificationManager.IMPORTANCE_LOW)
            nm.createNotificationChannel(channel)

        }

        nm.notify(NOTIFY_ID, builder.build())

    }

    private fun removeNotification(context: Context) {
        val nm = context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
        nm.cancel(NOTIFY_ID)
    }
}

/**
 * 网络请求判断
 */
fun networkIsConnected(context: Context): Boolean {
    val connectivityManager = context.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
    val activeNetworkInfo = connectivityManager.activeNetworkInfo
    return activeNetworkInfo?.isConnected == true
}

/**
 * 判断通知栏权限是否开启
 */
fun isNotificationEnabled(context: Context): Boolean {

//    if (1 == 1) {
//        return NotificationManagerCompat.from(context).areNotificationsEnabled()
//    }

    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
        //8.0手机以上
//        if ((context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager).importance == NotificationManager.IMPORTANCE_NONE) {
//            return false
//        }
        val notificationManager = context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
        val granted = notificationManager.importance
        val enabled = notificationManager.areNotificationsEnabled()

        //notificationManager.getNotificationChannel("").importance
        return enabled//granted &&
    }

    val CHECK_OP_NO_THROW = "checkOpNoThrow"
    val OP_POST_NOTIFICATION = "OP_POST_NOTIFICATION"

    val mAppOps = context.getSystemService(Context.APP_OPS_SERVICE) as AppOpsManager
    val appInfo = context.applicationInfo
    val pkg = context.applicationContext.packageName
    val uid = appInfo.uid

    var appOpsClass: Class<*>? = null

    try {
        appOpsClass = Class.forName(AppOpsManager::class.java.name)
        val checkOpNoThrowMethod = appOpsClass!!.getMethod(
            CHECK_OP_NO_THROW, Integer.TYPE, Integer.TYPE,
            String::class.java
        )
        val opPostNotificationValue = appOpsClass.getDeclaredField(OP_POST_NOTIFICATION)

        val value = opPostNotificationValue.get(Int::class.java) as Int
        return checkOpNoThrowMethod.invoke(mAppOps, value, uid, pkg) as Int == AppOpsManager.MODE_ALLOWED

    } catch (e: Exception) {
        e.printStackTrace()
    }

    return false
}

fun isNotificationChannelEnabled(context: Context, channelId: String = "my_channel_01"): Boolean {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
        if (!TextUtils.isEmpty(channelId)) {
            val manager = context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            val channel = manager.getNotificationChannel(channelId)
            if (channel != null) {
                return channel.importance != NotificationManager.IMPORTANCE_NONE
                        && NotificationManagerCompat.from(context).areNotificationsEnabled()
            }
            //   return channel != null && channel.importance != NotificationManager.IMPORTANCE_NONE
        }
        return NotificationManagerCompat.from(context).areNotificationsEnabled()
    }

    return NotificationManagerCompat.from(context).areNotificationsEnabled()
    //  return isNotificationEnabled(context)
}


fun notificationSettingIntent(context: Context): Intent {

    /**
     * 跳到通知栏设置界面
     * @param context
     */
    val localIntent = Intent()
    //直接跳转到应用通知设置的代码：
    if (android.os.Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
        localIntent.action = Settings.ACTION_APP_NOTIFICATION_SETTINGS//"android.settings.APP_NOTIFICATION_SETTINGS"
        localIntent.putExtra(Settings.EXTRA_APP_PACKAGE, context.packageName)
    } else if (android.os.Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
        localIntent.action = "android.settings.APP_NOTIFICATION_SETTINGS"
        localIntent.putExtra("app_package", context.packageName)
        localIntent.putExtra("app_uid", context.applicationInfo.uid)
    } else if (android.os.Build.VERSION.SDK_INT == Build.VERSION_CODES.KITKAT) {
        localIntent.action = Settings.ACTION_APPLICATION_DETAILS_SETTINGS
        localIntent.addCategory(Intent.CATEGORY_DEFAULT)
        localIntent.data = Uri.parse("package:" + context.getPackageName())
    } else {
        //4.4以下没有从app跳转到应用通知设置页面的Action，可考虑跳转到应用详情页面,
        localIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
        if (Build.VERSION.SDK_INT >= 9) {
            localIntent.action = "android.settings.APPLICATION_DETAILS_SETTINGS"
            localIntent.data = Uri.fromParts("package", context.getPackageName(), null)
        } else if (Build.VERSION.SDK_INT <= 8) {
            localIntent.action = Intent.ACTION_VIEW
            localIntent.setClassName("com.android.settings", "com.android.setting.InstalledAppDetails")
            localIntent.putExtra("com.android.settings.ApplicationPkgName", context.getPackageName())
        }
    }
    //context.startActivity(localIntent)
    return localIntent
}