package com.talpa.master.repository

import android.Manifest
import android.content.Context
import android.content.pm.PackageManager
import android.os.Build
import android.preference.PreferenceManager
import android.telephony.TelephonyManager
import android.text.TextUtils
import androidx.core.app.ActivityCompat
import com.cy.sts.common.Logcat
import com.flurry.android.FlurryAgent
import com.google.gson.Gson

import java.util.*

class Preferences {
    companion object{
        const val PERMISSION_MIC_SETUP = "MKF_startup"//麦克风权限启动
        const val PERMISSION_MIC_SWITCH = "MKF_switch"//麦克风权限开关 开，记录一次，关，记录一次
        const val PERMISSION_NOTIFY_SETUP = "PUSH_startup"//通知栏权限启动 调起权限，记录一次
        const val PERMISSION_NOTIFY_SWITCH = "push_switch"//通知栏权限开关 开，记录一次，关，记录一次
        const val PERMISSION_VIBRATION = "shake_startup"//震动开关 开，记录一次，关，记录一次
        const val RECORDING_COUNT = "voice_recording_usage_count"//语音录制使用次数 当用户按住（超过1秒）说话，记录一次，点击一次不计算
        const val TRANSLATION_USAGE_COUNT = "translation_usage_count"//翻译接口使用次数
        const val TRANSLATION_RESULT = "translation_result"//当用户翻译结果成功，呈现翻译内容，记录次数
        const val BUTTON_SOUND = "sound_button"//声音播放键,默认打开，当用户点击声音按钮，记录次数
        const val BUTTON_COPY = "copy_button"//复制按钮，当用户点击声音按钮，记录次数
        const val BUTTON_EDIT = "edit_button"//编辑按钮，当用户点击声音按钮，记录次数
        const val BUTTON_ROTATING = "rotating_font"//旋转字体按钮，当用户点击声音按钮，记录次数
        const val TB_001 = "TB_001"//网络异常报错,使用翻译过程中，发生网络异常事件记录次数
        const val TB_002 = "TB_002"//无网络 事件发生，记录一次
        const val TB_003 = "TB_003"//听不清楚 事件发生，记录一次
        const val SPEECH_TO_TEXT = "SPEECH_TO_TEXT"
        const val TRANSLATE = "TRANSLATE"
    }
}

/**
 * 获取源地区
 *
 */
fun getSourceLocale(context: Context): Locale {
    val languageTag = PreferenceManager
        .getDefaultSharedPreferences(context)
        .getString("sourceLocaleKey", Locale.getDefault().language)
    return Locale.forLanguageTag(languageTag)
}


/**
 * 保存源地区
 * @param languageTag
 */
fun saveSourceLocale(context: Context, languageTag: String) {

    val editor = PreferenceManager
        .getDefaultSharedPreferences(context)
        .edit()
    editor.putString("sourceLocaleKey", languageTag)
    editor.apply()

}

/**
 * 获取目标地区
 */
fun getTargetLocale(context: Context): Locale {
    val languageTag = PreferenceManager
        .getDefaultSharedPreferences(context)
        .getString("targetLocaleKey",Locale.ENGLISH.language)
    return Locale.forLanguageTag(languageTag)
}

/**
 * 保存目标地区
 * @param languageTag
 */
fun saveTargetLocale(context: Context, languageTag: String) {
    val editor = PreferenceManager
        .getDefaultSharedPreferences(context)
        .edit()
    editor.putString("targetLocaleKey", languageTag)
    editor.apply()
}


/**
 * 是否第一次进入主界面
 */
fun isFirstToMain(context: Context): Boolean {

    val preference = PreferenceManager
        .getDefaultSharedPreferences(context)
    val isFirstToMain = preference
        .getBoolean("key_is_first_to_main", true)

    if (isFirstToMain) {
        val editor = preference.edit()
        editor.putBoolean("key_is_first_to_main", !isFirstToMain)
        editor.apply()
    }


    return isFirstToMain
}

/**
 * 是否第一次进入主界面
 */
fun isFirstEnterApp(context: Context): Boolean {

    val preference = PreferenceManager
        .getDefaultSharedPreferences(context)
    val isFirstEnterApp = preference
        .getBoolean("key_is_first_enter_app", true)

    if (isFirstEnterApp) {
        val editor = preference.edit()
        editor.putBoolean("key_is_first_enter_app", !isFirstEnterApp)
        editor.apply()
    }

    return isFirstEnterApp

}

/**
 * 是否应该显示引导
 */
fun shouldShowGuide(context: Context): Boolean {
    val preference = PreferenceManager
        .getDefaultSharedPreferences(context)
    return preference
        .getBoolean("key_should_show_guide", true)
}

/**
 * 保存隐藏引导
 */
fun saveHideGuide(context: Context) {
    val preference = PreferenceManager
        .getDefaultSharedPreferences(context)
    preference.edit().putBoolean("key_should_show_guide", false).apply()
}

/**
 * 读取IMEI
 */
fun readIMEI(context: Context): String? {

    val preference = PreferenceManager
        .getDefaultSharedPreferences(context)
    var imei = preference.getString(KEY_IMEI, null)

    if (TextUtils.isEmpty(imei)) {
        val granted = ActivityCompat.checkSelfPermission(context, Manifest.permission.READ_PHONE_STATE)
        if (granted == PackageManager.PERMISSION_GRANTED) {
            val tm = context.getSystemService(Context.TELEPHONY_SERVICE) as TelephonyManager
            imei = if (Build.VERSION.SDK_INT > Build.VERSION_CODES.O) tm.imei else tm.deviceId
            preference.edit().putString(KEY_IMEI, imei).apply()
        }

    }

    return imei
}

fun logEvent(context: Context? = null, code: String, map: MutableMap<String, String> = mutableMapOf()) {
    map["IMEI"] = if (context != null) readIMEI(context) ?: "" else ""
    FlurryAgent.logEvent(
        code, map
    )

    Logcat.d("Flurry", "EventCode=$code  content=${Gson().toJson(map)}")
}


private const val KEY_IMEI = "key_imei"