package com.talpa.master.repository.room.dao

import androidx.room.*
import com.talpa.master.repository.room.model.LanguageModel
import com.talpa.master.repository.room.model.TranslateLanguage
import io.reactivex.Flowable

/**
 * Dao

 */
@Dao
interface AppDao {

    /* ******Local Language Start*********/

    @Insert(onConflict = OnConflictStrategy.ABORT)
    fun insertLanguage(language: List<LanguageModel.LanguageList>)//vararg

    @Query(value = "SELECT * FROM languageList WHERE resource=:resource")
    fun queryLanguage(resource: String = ""): Flowable<List<LanguageModel.LanguageList>>

    @Query(value = "SELECT * FROM languageList WHERE `key` LIKE  '%' || :key || '%'  LIMIT 1")
    fun queryLanguageByKey(key: String): Flowable<List<LanguageModel.LanguageList>>

    @Query(value = "SELECT * FROM languageList WHERE selected=:isSelect AND languageType=:languageType  LIMIT 1")
    fun queryLanguageBySelect(isSelect: Boolean = true, languageType: Int): Flowable<List<LanguageModel.LanguageList>>

    /**
     * 查询语言数量
     */
    @Query(value = "SELECT COUNT(*) FROM languageList")
    fun queryLanguageCount(): Long

    /**
     * 查询最近使用的语言
     */
    @Query(value = "SELECT * FROM languageList WHERE resource=:resource AND recently_time!=0 ORDER BY recently_time DESC LIMIT 3")
    fun queryRecentlyUsedLanguage(resource: String): Flowable<List<LanguageModel.LanguageList>>

    /**
     * 更新语言
     */
    @Update
    fun updateLanguage(vararg language: LanguageModel.LanguageList)

    /**
     * 更新语言
     */
    @Update
    fun updateLanguage(language: List<LanguageModel.LanguageList>)
    /* ******Local Language End*********/

    /* ******Translate Language Start*********/

    @Insert(onConflict = OnConflictStrategy.ABORT)
    fun insertTranslateLanguage(languages: List<TranslateLanguage>)

    /**
     * 通过通配符查询注意，例如
     * queryTranslateLanguage(%ch%, resource: String)
     */
    @Query(value = "SELECT `key` FROM translate_language WHERE `key` LIKE :key AND resource=:resource LIMIT 1")
    fun queryTranslateLanguage(key: String, resource: String): String?

    @Query(value = "SELECT COUNT(*) FROM translate_language")
    fun queryTranslateLanguageCount(): Long
    /* ******Translate Language End*********/

}