package com.talpa.master.repository.room.dao

import androidx.room.*
import com.talpa.master.repository.room.model.History
import io.reactivex.Flowable

@Dao
interface HistoryDao {

//    @Query("SELECT * FROM history ORDER BY mills DESC")
//    fun queryHistorys(): DataSource.Factory<Int, History>

    @Query("SELECT * FROM history WHERE id = :id")
    fun queryHistory(id: String): History?

    @Query("SELECT COUNT(*) FROM history")
    fun queryHistorySize(): Flowable<Int>

    @Query("SELECT * FROM history ORDER BY mills DESC LIMIT 1")
    fun queryLastHistory(): History

    @Query("SELECT * FROM history WHERE start_marker=1 ORDER BY mills DESC")
    fun queryAllHistoryByMark(): Flowable<List<History>>

    @Query("SELECT * FROM history ORDER BY mills DESC")
    fun queryLatestHistory(): Flowable<List<History>>

    @Query("SELECT * FROM history")
    fun all(): Flowable<List<History>>

    @Insert(onConflict = OnConflictStrategy.ABORT)
    fun insertHistory(historys: List<History>)

    @Insert
    fun insert(history: History)

    @Update(onConflict = OnConflictStrategy.REPLACE)
    fun updateStarModel(history: History)

    @Delete
    fun deleteHistory(history: History)
}