package com.talpa.master.repository.room.model

import androidx.annotation.Keep
import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey

@Entity(tableName = "history")
@Keep
data class History (
    @PrimaryKey
    @ColumnInfo(name = "id")  //每条数据的唯一标识
    var id: String,

    @ColumnInfo(name = "source_result")  //源语言内容
    var source_result: String = "",

    @ColumnInfo(name = "target_result")  //目标语言内容
    var target_result: String = "",

    @ColumnInfo(name = "display_type")  //显示类型  0源 背景色 绿色 1目标 背景色 蓝色
    var display_type: Int,

    @ColumnInfo(name = "result_type")  //翻译结果状态 0异常 1成功 2翻译中
    var result_type: Int?,

    @ColumnInfo(name = "error_code")  //异常状态
    var error_code: Int?,

    @ColumnInfo(name = "error_msg")  //异常状态说明
    var error_msg: String,

    @ColumnInfo(name = "mills")  //时间戳
    var mills: Long,

    @ColumnInfo(name = "is_delete")  //是否删除 软/硬删除
    var is_delete: Boolean = false,

    @ColumnInfo(name = "sourcelanguage_tag")  //源语言tag
    var sourcelanguage_tag: String = "",

    @ColumnInfo(name = "sourcelanguage_name")  //源语言名字
    var sourcelanguage_name: String = "",

    @ColumnInfo(name = "targetlanguage_tag")  //目标语言tag
    var targetlanguage_tag: String = "",

    @ColumnInfo(name = "targetlanguage_name")  //目标语言name
    var targetlanguage_name: String = "",

    @ColumnInfo(name = "start_marker")
    var isStartMarker: Boolean = false,  // 是否是星标

    @ColumnInfo(name = "voice_path")  //语音播报路径
    var voice_path: String = ""
)