package com.talpa.master.repository.room.model

import android.app.Application
import androidx.annotation.Keep
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import com.talpa.master.framework.RoomHelper
import com.talpa.master.framework.BaseViewModel
import com.talpa.master.repository.room.dao.HistoryDao

@Keep
class HistoryModel(val dao: HistoryDao) : BaseViewModel() {
    companion object {
        fun factory(application: Application) = object : ViewModelProvider.Factory{
            override fun <T : ViewModel?> create(modelClass: Class<T>): T {
                return HistoryModel(RoomHelper.historyDao) as T
            }
        }
    }
}