package com.talpa.master.ui.history

import androidx.lifecycle.ViewModelProviders
import androidx.recyclerview.widget.LinearLayoutManager
import com.talpa.master.R
import com.talpa.master.common.MediaPlayerHelper
import com.talpa.master.databinding.ActivityHistoryBinding
import com.talpa.master.databinding.DataBindingActivity

class HistoryActivity : DataBindingActivity<ActivityHistoryBinding>() {
    private val viewModel: HistoryViewModel by lazy {
        ViewModelProviders.of(this, HistoryViewModel.factory(application))
            .get(HistoryViewModel::class.java)
    }

    override fun getContentView(): Int = R.layout.activity_history
    override fun initView() {
        mBinding.rvHistory.layoutManager = LinearLayoutManager(this)
        mBinding.rvHistory.adapter = HistoryAdapter(viewModel)
    }

    override fun init() {
        mBinding.vm = viewModel
        viewModel.selectHistory()
        viewModel.historys.observe(this, {
            mBinding.rvHistory.adapter?.notifyDataSetChanged()
        })
    }

    override fun onDestroy() {
        super.onDestroy()
        MediaPlayerHelper.stopMusic()
    }


}