package com.talpa.master.ui.history

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.RecyclerView
import com.talpa.master.R
import com.talpa.master.databinding.ItemHistoryBinding
import com.talpa.master.repository.room.model.History
import com.talpa.master.ui.main.MainViewModel

/**
 * Create by kgxl on 2021/4/13
 */
class HistoryAdapter(private val viewModel: HistoryViewModel) :
    RecyclerView.Adapter<HistoryAdapter.HistoryViewHolder>() {

    inner class HistoryViewHolder(private val binding: ItemHistoryBinding) :
        RecyclerView.ViewHolder(binding.root) {
        private lateinit var mHistory: History
        private val itemClick = View.OnClickListener {
            when (it.id) {
                R.id.tv_main_result_copy -> {
                    mHistory?.let { history ->
                        viewModel.copyText(history, it)
                    }
                }
                R.id.tv_main_result_start -> {
                    mHistory?.let { history ->
                        viewModel.starMark(history, it)
                    }
                }
                R.id.tv_main_result_voice -> {
                    viewModel.speechPath = mHistory.voice_path
                    viewModel.playTranslateVoice(it)
                }
            }
        }

        fun bind(position: Int) {

            val history = viewModel.historys.value?.get(position)
            history?.let {
                mHistory = it
                when (it.display_type) {
                    MainViewModel.HistoryItemViewType.SOURCE.value -> {
                        binding.tvMainResultSource.text = it.target_result
                        binding.tvMainResultText.text = it.source_result
                        binding.historyParent.setBackgroundResource(viewModel.sourceBackground[position % 4])
                    }
                    MainViewModel.HistoryItemViewType.TARGET.value -> {
                        binding.tvMainResultText.text = it.target_result
                        binding.tvMainResultSource.text = it.source_result
                        binding.historyParent.setBackgroundResource(viewModel.targetBackground[position % 4])
                    }
                }
                if (history.isStartMarker) {
                    binding.tvMainResultStart.setBackgroundResource(R.drawable.ic_collected)
                } else {
                    binding.tvMainResultStart.setBackgroundResource(R.drawable.ic_collect)
                }
                binding.tvMainResultStart.setOnClickListener(itemClick)
                binding.tvMainResultCopy.setOnClickListener(itemClick)
                binding.tvMainResultVoice.setOnClickListener(itemClick)
            }
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): HistoryViewHolder {
        val inflater = LayoutInflater.from(parent.context)
        val bind =
            DataBindingUtil.inflate<ItemHistoryBinding>(inflater, R.layout.item_history, parent, false)
        return HistoryViewHolder(bind)
    }

    override fun onBindViewHolder(holder: HistoryViewHolder, position: Int) {
        holder.bind(position)
    }

    override fun getItemCount(): Int = viewModel.historys.value?.size ?: 0
}