package com.talpa.master.ui.main

import android.app.Application
import androidx.fragment.app.FragmentActivity
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.ViewModelProviders
import com.talpa.master.framework.RoomHelper
import com.talpa.master.repository.room.model.LanguageModel
import com.talpa.master.framework.BaseViewModel
import com.talpa.master.framework.Repository
import io.reactivex.schedulers.Schedulers
import java.util.*


class ChoiceViewModel(repository: Repository, ctx: Application) : BaseViewModel() {
    companion object {
        fun factory(application: Application) = object : ViewModelProvider.Factory {
            override fun <T : ViewModel> create(modelClass: Class<T>): T {
                return ChoiceViewModel(Repository(), application) as T
            }
        }

        fun viewModel(fragmentActivity: FragmentActivity) = ViewModelProviders.of(fragmentActivity, factory(fragmentActivity.application)).get(MainViewModel::class.java)
    }

    var isDark = MutableLiveData<Boolean>()
    var sourceLanguage = MutableLiveData<LanguageModel.LanguageList>()
    var targetLanguage = MutableLiveData<LanguageModel.LanguageList>()

    fun localLanguage() {
        val languageTag = Locale.getDefault().language
        RoomHelper.appDao.queryLanguageByKey(languageTag).subscribeOn(Schedulers.io()).map {
            it[0]
        }.subscribe {
            sourceLanguage.postValue(it)
        }

        RoomHelper.appDao.queryLanguageByKey("en").subscribeOn(Schedulers.io()).map {
            it[0]
        }.subscribe {
                targetLanguage.postValue(it)
        }

    }
}