package com.talpa.master.ui.main

import android.app.Application
import android.view.View
import androidx.fragment.app.FragmentActivity
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.ViewModelProviders
import com.google.android.material.snackbar.BaseTransientBottomBar
import com.google.android.material.snackbar.Snackbar
import com.talpa.master.R
import com.talpa.master.common.MediaPlayerHelper
import com.talpa.master.framework.BaseViewModel
import com.talpa.master.framework.Repository


class ResultViewModel(repository: Repository, val ctx: Application) : BaseViewModel() {
    var speechPath: String = ""

    companion object {
        fun factory(application: Application) = object : ViewModelProvider.Factory {
            override fun <T : ViewModel> create(modelClass: Class<T>): T {
                return ResultViewModel(Repository(), application) as T
            }
        }

        fun viewModel(fragmentActivity: FragmentActivity) = ViewModelProviders.of(fragmentActivity, factory(fragmentActivity.application)).get(MainViewModel::class.java)
    }

    fun playTranslateVoice(v: View) {
        if (!speechPath.isNullOrEmpty()) {
            stopTranslateVoice()
//            playState.value = MainViewModel.PlayState.Playing
            MediaPlayerHelper.playMusic(ctx, speechPath, null, null)
        } else {
            val snackBar = Snackbar.make(v, R.string.read_fail, Snackbar.LENGTH_SHORT)
            snackBar.animationMode = BaseTransientBottomBar.ANIMATION_MODE_FADE
            snackBar.show()
        }
    }

    fun stopTranslateVoice() {
        speechPath?.let {
//            playState.value = MainViewModel.PlayState.Enabled
            MediaPlayerHelper.stopMusic()
        }
    }
}