package com.talpa.master.ui.main.adapter

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.CheckBox
import androidx.recyclerview.widget.RecyclerView
import com.talpa.master.databinding.ItemChoiceLanguageBinding
import com.talpa.master.framework.RoomHelper
import com.talpa.master.repository.room.model.LanguageModel
import com.talpa.master.ui.main.MainViewModel
import io.reactivex.Flowable
import io.reactivex.schedulers.Schedulers

/**
 * Create by kgxl on 2021/4/8
 */
class ChoiceLanguageAdapter(private val vm: MainViewModel) :
    RecyclerView.Adapter<ChoiceLanguageAdapter.ItemViewHolder>() {
    private var isFirstLoad: Boolean = true

    inner class ItemViewHolder(private val bind: ItemChoiceLanguageBinding) :
        RecyclerView.ViewHolder(bind.root) {
        private lateinit var currentData: LanguageModel.LanguageList
        private val itemClick = View.OnClickListener {
            click()
        }
        private val itemCheck = View.OnClickListener {
            if((it as CheckBox).isChecked)
                click()
        }

        private fun click() {
            vm.hideDialog.postValue(true)
            currentData.isSelected = true
            if (vm.currentLangType == MainViewModel.LanguageType.SOURCE) {
                currentData.languageType = MainViewModel.LanguageType.SOURCE.value
                vm.sourceLang.postValue(currentData)
            } else if (vm.currentLangType == MainViewModel.LanguageType.TARGET) {
                currentData.languageType = MainViewModel.LanguageType.TARGET.value
                vm.targetLang.postValue(currentData)
            }
            // 更新数据库
            updateSQLite()
        }

        /**
         * 更新数据库
         */
        private fun updateSQLite() {
            Flowable.fromCallable {
                val language = vm.languages.value?.filter {
                    if (it.isSelected && currentData != it && it.languageType == currentData.languageType) {
                        it.isSelected = false
                        true
                    } else it == currentData
                }
                language?.let { lang -> RoomHelper.appDao.updateLanguage(lang) }
            }.subscribeOn(Schedulers.computation()).subscribe()
        }


        fun bind(data: LanguageModel.LanguageList) {
            currentData = data
            bind.language = data.name
            bind.key = data.key
            val isCheck = vm.langCheck.get(position)
            if (bind.isSelect != isCheck) {
                bind.isSelect = isCheck
            }
            bind.mItemClickListener = itemClick
            bind.cbCheckLanguage.setOnClickListener(itemCheck)
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ItemViewHolder {
        val layoutInflater = LayoutInflater.from(parent.context)
        return ItemViewHolder(ItemChoiceLanguageBinding.inflate(layoutInflater, parent, false))
    }

    override fun onBindViewHolder(holder: ItemViewHolder, position: Int) {
        vm.languages.value?.let { holder.bind(it[position]) }
    }

    override fun getItemCount(): Int {
        return vm.languages.value?.size ?: 0
    }
}