package com.talpa.master.ui.main.fragment

import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.util.DisplayMetrics
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import androidx.lifecycle.ViewModelProviders
import com.talpa.master.R
import com.talpa.master.TranslateApplication
import com.talpa.master.databinding.DataBindingDialogFragment
import com.talpa.master.databinding.FragmentChoiceLanguageBinding
import com.talpa.master.framework.RoomHelper
import com.talpa.master.repository.saveSourceLocale
import com.talpa.master.repository.saveTargetLocale
import com.talpa.master.ui.main.ChoiceViewModel
import com.talpa.master.ui.main.MainViewModel
import com.talpa.master.utils.AppUtil
import com.talpa.master.utils.SharedPreferenceHelper
import com.talpa.master.utils.DpUtils
import io.reactivex.Flowable
import io.reactivex.schedulers.Schedulers

/**
 * Create by  on 2021/4/5
 */
class ChoiceLanguageFragment : DataBindingDialogFragment<FragmentChoiceLanguageBinding>(), View.OnClickListener {
    companion object {
        val TAG: String = ChoiceLanguageFragment::class.java.simpleName
        fun getInstance(): ChoiceLanguageFragment {
            return ChoiceLanguageFragment()
        }
    }

    //todo 两个viewModel耦合严重
    private val viewModel: ChoiceViewModel by lazy {
        ViewModelProviders.of(this, ChoiceViewModel.factory(activity!!.application)).get(ChoiceViewModel::class.java)
    }


    private val mainViewModel: MainViewModel by lazy {
        ViewModelProviders.of(this, MainViewModel.factory(activity!!.application)).get(MainViewModel::class.java)
    }

    private val choiceLanguageListFragment by lazy { ChoiceLanguageListFragment.getInstance(mainViewModel) }


    override fun onStart() {
        super.onStart()
        //设置大小
        val win = dialog!!.window
        // 一定要设置Background，如果不设置，window属性设置无效
        win!!.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
        val dm = DisplayMetrics()
        activity!!.windowManager.defaultDisplay.getMetrics(dm)
        val params = win!!.attributes
        params.gravity = Gravity.BOTTOM
        // 使用ViewGroup.LayoutParams，以便Dialog 宽度充满整个屏幕
        params.width = ViewGroup.LayoutParams.MATCH_PARENT
        params.height = DpUtils.dip2px(TranslateApplication.mApplicationContext, 398f)
        win!!.attributes = params
        dialog!!.setCanceledOnTouchOutside(false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        mBinding.vm = viewModel
        initView()
    }

    private fun initView() {
        val darkTheme = AppUtil.isDarkTheme(TranslateApplication.mApplicationContext)
        viewModel.isDark.postValue(darkTheme)
        viewModel.localLanguage()
        if (mainViewModel.currentLangType == MainViewModel.LanguageType.SOURCE) {
            mBinding.tvChoiceLanguageTitle.setText(R.string.you_say)
        } else {
            mBinding.tvChoiceLanguageTitle.setText(R.string.he_say)
        }
        mainViewModel.hideDialog.observe(this, {
            choiceLanguageListFragment.dismissAllowingStateLoss()
        })
        mainViewModel.sourceLang.observe(this, {
            viewModel.sourceLanguage.postValue(it)
            saveSourceLocale(context!!, it.key)
        })
        mainViewModel.targetLang.observe(this, {
            viewModel.targetLanguage.postValue(it)
            saveTargetLocale(context!!, it.key)
        })
        mBinding.tvStartUsing.setOnClickListener(this)
        mBinding.tvYouSayLanguage.setOnClickListener(this)
        mBinding.tvHeSayLanguage.setOnClickListener(this)
    }

    override fun getContentView(): Int = R.layout.fragment_choice_language

    override fun onClick(v: View) {
        when (v.id) {
            R.id.tv_start_using -> {
                Flowable.fromCallable {
                    viewModel.sourceLanguage.value?.apply {
                        this.isSelected = true
                        this.languageType = MainViewModel.LanguageType.SOURCE.value
                        RoomHelper.appDao.updateLanguage(this)
                    }
                    viewModel.targetLanguage.value?.apply {
                        this.isSelected = true
                        this.languageType = MainViewModel.LanguageType.TARGET.value
                        RoomHelper.appDao.updateLanguage(this)
                    }
                }.subscribeOn(Schedulers.io()).subscribe()
                SharedPreferenceHelper.putBooleanValue(SharedPreferenceHelper.IS_FIRST_OPEN, false)
                this.dismissAllowingStateLoss()
            }
            // 你说
            R.id.tv_you_say_language -> {
                println("你说")
                mainViewModel.currentLangType = MainViewModel.LanguageType.SOURCE
                choiceLanguageListFragment.show(activity!!.supportFragmentManager, ChoiceLanguageListFragment.TAG)
            }

            // 他说
            R.id.tv_he_say_language -> {
                println("他说")
                mainViewModel.currentLangType = MainViewModel.LanguageType.TARGET
                choiceLanguageListFragment.show(activity!!.supportFragmentManager, ChoiceLanguageListFragment.TAG)

            }
        }
    }
}


