package com.talpa.master.ui.main.fragment

import android.os.Bundle
import android.util.DisplayMetrics
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.LinearLayoutManager
import com.talpa.master.R
import com.talpa.master.TranslateApplication
import com.talpa.master.databinding.DataBindingDialogFragment
import com.talpa.master.databinding.FragmentChoiceLanguageListBinding
import com.talpa.master.ui.main.MainViewModel
import com.talpa.master.ui.main.adapter.ChoiceLanguageAdapter
import com.talpa.master.utils.DpUtils

/**
 * Create by  on 2021/4/5
 */
class ChoiceLanguageListFragment(private val viewModel: MainViewModel) :
    DataBindingDialogFragment<FragmentChoiceLanguageListBinding>() {
    companion object {
        val TAG: String = ChoiceLanguageListFragment::class.java.name
        fun getInstance(vm: MainViewModel): ChoiceLanguageListFragment {
            return ChoiceLanguageListFragment(vm)
        }
    }

    override fun onStart() {
        super.onStart()
        val win = dialog!!.window
//        win!!.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
        val dm = DisplayMetrics()
        activity!!.windowManager.defaultDisplay.getMetrics(dm)
        val params = win!!.attributes
        params.gravity = Gravity.BOTTOM
        params.width = ViewGroup.LayoutParams.MATCH_PARENT
        params.height = DpUtils.dip2px(TranslateApplication.mApplicationContext, 398f)
        win!!.attributes = params
        dialog!!.setCanceledOnTouchOutside(true)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        initLanguageList()
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        initView()
    }

    // 初始化
    private fun initView() {
        if(viewModel.currentLangType==MainViewModel.LanguageType.SOURCE){
            mBinding.tvChoiceLanguageListTitle.setText(R.string.you_say)
        }else{
            mBinding.tvChoiceLanguageListTitle.setText(R.string.he_say)

        }

        mBinding.rvChoiceLanguage.layoutManager = LinearLayoutManager(context)
        mBinding.rvChoiceLanguage.adapter = ChoiceLanguageAdapter(viewModel)
    }

    // 语言列表
    private fun initLanguageList() {
        viewModel.getLocalAllLanguage()
        viewModel.languages.observe(this, { //需要优化数据刷新
            var selectIndex = 0
            it.forEachIndexed { index, languageList ->
                val isSelect = languageList.isSelected && languageList.languageType == viewModel.currentLangType.value
                if (isSelect) selectIndex = index
                viewModel.langCheck.put(index, isSelect)
            }
            mBinding.rvChoiceLanguage.adapter?.notifyDataSetChanged()
            mBinding.rvChoiceLanguage.smoothScrollToPosition(selectIndex)
        })
    }

    override fun getContentView(): Int = R.layout.fragment_choice_language_list

}


