package com.talpa.master.ui.main.fragment

import android.app.Dialog
import android.content.DialogInterface
import android.content.pm.PackageManager
import android.os.Bundle
import android.view.View
import android.view.WindowManager
import android.view.animation.AnimationUtils
import com.talpa.master.R
import com.talpa.master.databinding.DataBindingDialogFragment
import com.talpa.master.databinding.FragmentPermissionBinding
import com.talpa.master.repository.Preferences.Companion.PERMISSION_MIC_SETUP
import com.talpa.master.repository.Preferences.Companion.PERMISSION_MIC_SWITCH
import com.talpa.master.repository.logEvent

/**
 * 權限請求
 */
class PermissionFragment: DataBindingDialogFragment<FragmentPermissionBinding>() {
    override fun getContentView():Int = R.layout.fragment_permission
    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        logEvent(
            context = activity!!,
            code = PERMISSION_MIC_SETUP
        )
    }

    override fun onResume() {
        super.onResume()
        dialog?.window?.setLayout(
            WindowManager.LayoutParams.MATCH_PARENT,
            WindowManager.LayoutParams.MATCH_PARENT
        )
        val params = dialog?.window?.attributes
        params?.verticalMargin = 0.1f
    }

    override fun onPause() {
        super.onPause()
    }

    override fun onDestroy() {
        super.onDestroy()
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        mBinding.setOnAuthClick {
            requestPermission()
        }

        mBinding.setOnCloseClick {
            dismissAllowingStateLoss()
        }
    }

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        return super.onCreateDialog(savedInstanceState)
    }

    private fun requestPermission() {
        requestPermissions(arrayOf(android.Manifest.permission.RECORD_AUDIO), 200)
    }

    override fun onRequestPermissionsResult(requestCode: Int, permissions: Array<out String>, grantResults: IntArray) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults)
        if (requestCode == 200) {
            for ((index, permission) in permissions.withIndex()) {
                if (permission == android.Manifest.permission.RECORD_AUDIO) {
                    val granted = grantResults[index] == PackageManager.PERMISSION_GRANTED
                    if (granted) {
                        mBinding.ivMicroUnabled.visibility = View.GONE
                    }
                    logEvent(
                        context = mBinding.root.context,
                        code = PERMISSION_MIC_SWITCH,
                        map = mutableMapOf("granted" to granted.toString())
                    )
                }
            }
            view?.postDelayed({
                dismiss()
            }, 200)
        }
    }

    override fun getTheme(): Int = R.style.PermissionTheme


    private fun inAnim() {
        val root = mBinding.root
        val animation = AnimationUtils.loadAnimation(root.context, R.anim.slide_in_bottom)
        root.startAnimation(animation)
    }

    private fun outAnim() {
        val root = mBinding.root
        val animation = AnimationUtils.loadAnimation(root.context, R.anim.slide_out_bottom)
        root.startAnimation(animation)
    }

    override fun onDismiss(dialog: DialogInterface) {
        super.onDismiss(dialog)
    }
}