package com.talpa.master.ui.main.fragment

import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.util.DisplayMetrics
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import androidx.lifecycle.ViewModelProviders
import com.talpa.master.R
import com.talpa.master.databinding.DataBindingDialogFragment
import com.talpa.master.databinding.FragmentTranslateResultBinding
import com.talpa.master.ex.RxEx
import com.talpa.master.framework.RoomHelper
import com.talpa.master.ui.main.MainViewModel
import com.talpa.master.ui.main.ResultViewModel
import io.reactivex.Flowable

/**
 * Create by  on 2021/4/5
 */
class TranslateResultFragment : DataBindingDialogFragment<FragmentTranslateResultBinding>(), View.OnClickListener {
    companion object {
        val TAG: String = TranslateResultFragment::class.java.simpleName
        val HISTORY_ID: String = "histroyId"
        fun getInstance(historyId: String): TranslateResultFragment {
            val bundle = Bundle()
            bundle.putString(HISTORY_ID, historyId)
            val translateResultFragment = TranslateResultFragment()
            translateResultFragment.arguments = bundle
            return translateResultFragment
        }
    }

    private val viewModel: ResultViewModel by lazy {
        ViewModelProviders.of(this, ResultViewModel.factory(activity!!.application)).get(ResultViewModel::class.java)
    }

    override fun onStart() {
        super.onStart()
        //设置大小
        val win = dialog!!.window
        // 一定要设置Background，如果不设置，window属性设置无效
        win!!.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
        val dm = DisplayMetrics()
        activity!!.windowManager.defaultDisplay.getMetrics(dm)
        val params = win!!.attributes
        params.gravity = Gravity.BOTTOM
        // 使用ViewGroup.LayoutParams，以便Dialog 宽度充满整个屏幕
        params.width = ViewGroup.LayoutParams.MATCH_PARENT
        params.height = ViewGroup.LayoutParams.MATCH_PARENT
        win!!.attributes = params
        dialog!!.setCanceledOnTouchOutside(false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        initView()
        initData()
    }

    private fun initData() {
        val historyId = arguments?.getString(HISTORY_ID)
        historyId?.let {
            Flowable.fromCallable {
                RoomHelper.historyDao.queryHistory(historyId)
            }.compose(RxEx.io4mainFlowable()).subscribe {
                it?.let {
                    viewModel.speechPath = it.voice_path
                    when (it.display_type) {
                        MainViewModel.HistoryItemViewType.TARGET.value -> {
                            mBinding.tvResultLang.text = it.sourcelanguage_name
                            mBinding.tvResultContent.text = it.source_result
                        }
                        MainViewModel.HistoryItemViewType.SOURCE.value -> {
                            mBinding.tvResultLang.text = it.targetlanguage_name
                            mBinding.tvResultContent.text = it.target_result
                        }
                    }
                }
            }
        }
    }

    private fun initView() {
        mBinding.fabResult.setOnClickListener(this)
        mBinding.tvResultSpeech.setOnClickListener(this)
    }

    override fun getContentView(): Int = R.layout.fragment_translate_result
    override fun onClick(v: View) {
        when (v.id) {
            R.id.fab_result -> {
                viewModel.stopTranslateVoice()
                dismissAllowingStateLoss()
            }
            R.id.tv_result_speech -> {
                viewModel.playTranslateVoice(v)
            }
        }
    }

}


